/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Roger Chickering (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_OVERRIDE_ELEMENT
#define  _SO_OVERRIDE_ELEMENT

#include <Inventor/elements/SoSubElement.h>
#include <Inventor/STL/bitset>

//
// Macro to implement get*Override inline methods.  There are a lot of
// these methods, each of which has an identical implementation and
// which needs to be inline to keep traversal fast.
#define SO_GET_OVERRIDE(flag)     \
  const SoOverrideElement *elt;                                       \
  elt = SoElement::getConstElement<SoOverrideElement>(state);         \
  return (elt->m_flags.test(flag));

//
// Implement set*Override methods.
//
#define SO_SET_OVERRIDE(flag)                                       \
  SoOverrideElement   *elt;                                         \
  elt = SoElement::getElement<SoOverrideElement>(state);            \
  if (override)                                                     \
    elt->m_flags.set(flag);                                         \
  else                                                              \
    elt->m_flags.reset(flag);

/**
*   Stores a flag for each type of element which can be
*   overridden.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores a flag for each type of element which can be
*   overridden. Nodes implement override by setting the appropriate
*   bit if their override flag is on, and ignoring overridden elements
*   if the corresponding bit in the state's SoOverrideElement is set.
*
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoOverrideElement : public SoElement {

  SO_ELEMENT_HEADER(SoOverrideElement);

 public:

  /**
  *  Overrides push() method to copy values from next instance in
  *  the stack, and set up cache dependencies correctly.
  */
  virtual void push(SoState *state);

  //
  // "get" methods for each element which can be overridden.
  //

  /**
  *  Returns TRUE if SoAmbientColorElement is overridden.
  */
  static SbBool getAmbientColorOverride(SoState *state)
    { SO_GET_OVERRIDE(AMBIENT_COLOR); }

  /**
  *  Returns TRUE if SoColorIndexElement is overridden.
  */
  static SbBool getColorIndexOverride(SoState *state)
    { SO_GET_OVERRIDE(COLOR_INDEX); }

  /**
  *  Returns TRUE if SoComplexityElement is overridden.
  */
  static SbBool getComplexityOverride(SoState *state)
    { SO_GET_OVERRIDE(COMPLEXITY); }

  /**
  *  Returns TRUE if SoComplexityTypeElement is overridden.
  */
  static SbBool getComplexityTypeOverride(SoState *state)
    { SO_GET_OVERRIDE(COMPLEXITY_TYPE); }

  /**
  *  Returns TRUE if SoCreaseAngleElement is overridden.
  */
  static SbBool getCreaseAngleOverride(SoState *state)
    { SO_GET_OVERRIDE(CREASE_ANGLE); }

  /**
  *  Returns TRUE if SoNeighborToleranceElement is overridden.
  */
  static SbBool getNeighborToleranceOverride(SoState *state)
    { SO_GET_OVERRIDE(NEIGHBOR_TOLERANCE); }

  /**
  *  Returns TRUE if SoDiffuseColorElement is overridden.
  */
  static SbBool getDiffuseColorOverride(SoState *state)
    { SO_GET_OVERRIDE(DIFFUSE_COLOR); }

  /**
  *  Returns TRUE if SoDrawStyleElement is overridden.
  */
  static SbBool getDrawStyleOverride(SoState *state)
    { SO_GET_OVERRIDE(DRAW_STYLE); }

  /**
  *  Returns TRUE if SoEmissiveColorElement is overridden.
  */
  static SbBool getEmissiveColorOverride(SoState *state)
    { SO_GET_OVERRIDE(EMISSIVE_COLOR); }

  /**
  *  Returns TRUE if SoFontNameElement is overridden.
  */
  static SbBool getFontNameOverride(SoState *state)
    { SO_GET_OVERRIDE(FONT_NAME); }

  /**
  *  Returns TRUE if SoFontSizeElement is overridden.
  */
  static SbBool getFontSizeOverride(SoState *state)
    { SO_GET_OVERRIDE(FONT_SIZE); }

  /**
  *  Returns TRUE if SoFontRenderStyleElement is overridden.
  */
  static SbBool getFontRenderStyleOverride(SoState *state)
    { SO_GET_OVERRIDE(FONT_RENDERSTYLE); }

  /**
  *  Returns TRUE if SoLightModelElement is overridden.
  */
  static SbBool getLightModelOverride(SoState *state)
    { SO_GET_OVERRIDE(LIGHT_MODEL); }

  /**
  *  Returns TRUE if SoLinePatternElement is overridden.
  */
  static SbBool getLinePatternOverride(SoState *state)
    { SO_GET_OVERRIDE(LINE_PATTERN); }

  /**
  *  Returns TRUE if SoLineWidthElement is overridden.
  */
  static SbBool getLineWidthOverride(SoState *state)
    { SO_GET_OVERRIDE(LINE_WIDTH); }

  /**
  *  Returns TRUE if SoMaterialBindingElement is overridden.
  */
  static SbBool getMaterialBindingOverride(SoState *state)
    { SO_GET_OVERRIDE(MATERIAL_BINDING); }

  /**
  *  Returns TRUE if SoPointSizeElement is overridden.
  */
  static SbBool getPointSizeOverride(SoState *state)
    { SO_GET_OVERRIDE(POINT_SIZE); }

  /**
  *  Returns TRUE if SoPickStyleElement is overridden.
  */
  static SbBool getPickStyleOverride(SoState *state)
    { SO_GET_OVERRIDE(PICK_STYLE); }

  /**
  *  Returns TRUE if SoShapeHintsElement is overridden.
  */
  static SbBool getShapeHintsOverride(SoState *state)
    { SO_GET_OVERRIDE(SHAPE_HINTS); }

  /**
  *  Returns TRUE if SoShininessElement is overridden.
  */
  static SbBool getShininessOverride(SoState *state)
    { SO_GET_OVERRIDE(SHININESS); }

  /**
   * Returns TRUE if SoPhysicalMaterial::specular is overridden.
   */
  static SbBool getSpecularFactorOverride(SoState* state)
  {
    SO_GET_OVERRIDE(SPECULAR_FACTOR);
  }

  /**
   * Returns TRUE if SoPhysicalMaterial::roughness is overridden.
   */
  static SbBool getRoughnessOverride(SoState* state)
  {
    SO_GET_OVERRIDE(ROUGHNESS);
  }

  /**
   * Returns TRUE if SoPhysicalMaterial::metallic is overridden.
   */
  static SbBool getMetallicOverride(SoState* state)
  {
    SO_GET_OVERRIDE(METALLIC);
  }

  /**
  *  Returns TRUE if SoSpecularColorElement is overridden.
  */
  static SbBool getSpecularColorOverride(SoState *state)
    { SO_GET_OVERRIDE(SPECULAR_COLOR); }

  /**
  *  Returns TRUE if SoTransparencyElement is overridden.
  */
  static SbBool getTransparencyOverride(SoState *state)
    { SO_GET_OVERRIDE(TRANSPARENCY); }

  /**
  *  Returns TRUE if SoTransparencyTypeElement is overridden.
  */
  static SbBool getTransparencyTypeOverride(SoState *state)
    { SO_GET_OVERRIDE(TRANSPARENCY_TYPE); }

  /**
  *  Returns TRUE if SoEnvironmentElement is overridden.
  */
  static SbBool getEnvironmentOverride(SoState *state)
    { SO_GET_OVERRIDE(ENVIRONMENT); }

  /**
   * Returns TRUE if SoEnvironmentMap is overridden.
   */
  static SbBool getEnvironmentMapOverride(SoState* state)
  {
    SO_GET_OVERRIDE(ENVIRONMENT_MAP);
  }

  /**
  *  Returns TRUE if SoPolygonOffsetElement is overridden.
  */
  static SbBool getPolygonOffsetOverride(SoState *state)
    { SO_GET_OVERRIDE(POLYGON_OFFSET); }

  /**
  *  Returns TRUE if SoPatternElement is overriden.
  */
  static SbBool getPatternOverride(SoState* state)
    { SO_GET_OVERRIDE(PATTERN_OFFSET); }

  /**
  *  Returns TRUE if SoFullSceneAntialiasingElement is overridden.
  */
  static SbBool getFullSceneAntialiasingOverride(SoState *state)
    { SO_GET_OVERRIDE(FULL_SCENE_ANTIALIASING); }

  /**
  *  Returns TRUE if SoDepthBuffer::range  is overridden.
  */
  static SbBool getDepthBufferRangeOverride(SoState *state)
    { SO_GET_OVERRIDE(DEPTH_BUFFER_RANGE); }

  /**
  *  Returns TRUE if SoDepthBuffer::function is overridden.
  */
  static SbBool getDepthBufferFunctionOverride(SoState *state)
    { SO_GET_OVERRIDE(DEPTH_BUFFER_FUNCTION); }

  /**
  *  Returns TRUE if SoComplexityType::bboxType is overridden.
  */
  static SbBool getBBoxTypeOverride(SoState *state)
    { SO_GET_OVERRIDE(BBOX_TYPE); }


  //
  // "set" methods for each element which can be overridden.
  //

  /**
  *  Set override flag for SoAmbientColorElement.
  */
  static void setAmbientColorOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(AMBIENT_COLOR); }

  /**
  *  Set override flag for SoColorIndexElement.
  */
  static void setColorIndexOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(COLOR_INDEX); }

  /**
  *  Set override flag for SoComplexityElement.
  */
  static void setComplexityOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(COMPLEXITY); }

  /**
  *  Set override flag for SoComplexityTypeElement.
  */
  static void setComplexityTypeOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(COMPLEXITY_TYPE); }

  /**
  *  Set override flag for SoCreaseAngleElement.
  */
  static void setCreaseAngleOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(CREASE_ANGLE); }

  /**
  *  Set override flag for SoNeighborToleranceElement.
  */
  static void setNeighborToleranceOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(NEIGHBOR_TOLERANCE); }

  /**
  *  Set override flag for SoDiffuseColorElement.
  */
  static void setDiffuseColorOverride(SoState *state, SoNode *, SbBool override);

  /**
  *  Set override flag for SoDrawStyleElement.
  */
  static void setDrawStyleOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(DRAW_STYLE); }

  /**
  *  Set override flag for SoEmissiveColorElement.
  */
  static void setEmissiveColorOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(EMISSIVE_COLOR); }

  /**
  *  Set override flag for SoFontNameElement.
  */
  static void setFontNameOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(FONT_NAME); }

  /**
  *  Set override flag for SoFontSizeElement.
  */
  static void setFontSizeOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(FONT_SIZE); }

  /**
  *  Set override flag for SoFontRenderStyleElement.
  */
  static void setFontRenderStyleOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(FONT_RENDERSTYLE); }

  /**
  *  Set override flag for SoLightModelElement.
  */
  static void setLightModelOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(LIGHT_MODEL); }

  /**
  *  Set override flag for SoLinePatternElement.
  */
  static void setLinePatternOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(LINE_PATTERN); }

  /**
  *  Set override flag for SoLineWidthElement.
  */
  static void setLineWidthOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(LINE_WIDTH); }

  /**
  *  Set override flag for SoMaterialBindingElement.
  */
  static void setMaterialBindingOverride(SoState *state, SoNode *, SbBool override);

  /**
  *  Set override flag for SoPickStyleElement.
  */
  static void setPickStyleOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(PICK_STYLE); }

  /**
  *  Set override flag for SoPointSizeElement.
  */
  static void setPointSizeOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(POINT_SIZE); }

  /**
  *  Set override flag for SoShapeHintsElement.
  */
  static void setShapeHintsOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(SHAPE_HINTS); }

  /**
  *  Set override flag for SoShininessElement.
  */
  static void setShininessOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(SHININESS); }

  /**
   * Set override flag for SoPhysicalMaterial::specular.
   */
  static void setSpecularFactorOverride(SoState* state, SoNode*, SbBool override)
  {
    SO_SET_OVERRIDE(SPECULAR_FACTOR);
  }

  /**
   * Set override flag for SoPhysicalMaterial::roughness.
   */
  static void setRoughnessOverride(SoState* state, SoNode*, SbBool override)
  {
    SO_SET_OVERRIDE(ROUGHNESS);
  }

  /**
   * Set override flag for SoPhysicalMaterial::metallic.
   */
  static void setMetallicOverride(SoState* state, SoNode*, SbBool override)
  {
    SO_SET_OVERRIDE(METALLIC);
  }

  /**
  *  Set override flag for SoSpecularColorElement.
  */
  static void setSpecularColorOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(SPECULAR_COLOR); }

  /**
  *  Set override flag for SoTransparencyElement.
  */
  static void setTransparencyOverride(SoState *state, SoNode *, SbBool override);

  /**
  *  Set override flag for SoTransparencyTypeElement.
  */
  static void setTransparencyTypeOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(TRANSPARENCY_TYPE); }

  /**
  *  Set override flag for SoEnvironmentElement.
  */
  static void setEnvironmentOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(ENVIRONMENT); }

  /**
   * Set override flag for SoEnvironmentMap.
   */
  static void setEnvironmentMapOverride(SoState* state, SoNode*, SbBool override)
  {
    SO_SET_OVERRIDE(ENVIRONMENT_MAP);
  }

  /**
  *  Set override flag for SoPolygonOffsetElement.
  */
  static void setPolygonOffsetOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(POLYGON_OFFSET); }

  /**
  *  Set override flag for SoPatternElement.
  */
  static void setPatternOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(PATTERN_OFFSET); }

  /**
  *  Set override flag for SoFullSceneAntialiasingElement.
  */
  static void setFullSceneAntialiasingOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(FULL_SCENE_ANTIALIASING); }

  /**
  *  Set override flag for SoDepthBuffer::range.
  */
  static void setDepthBufferRangeOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(DEPTH_BUFFER_RANGE); }

  /**
  *  Set override flag for SoDepthBuffer::function.
  */
  static void setDepthBufferFunctionOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(DEPTH_BUFFER_FUNCTION); }

  /**
  *  Set override flag for SoComplexity::bboxType.
  */
  static void setBBoxTypeOverride(SoState *state, SoNode *, SbBool override)
    { SO_SET_OVERRIDE(BBOX_TYPE); }

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Comparison based on value of int32_ts.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /** Copy method, copies flags */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  enum Defined_Override_Bit {
    AMBIENT_COLOR= 0,
    COLOR_INDEX,
    COMPLEXITY,
    COMPLEXITY_TYPE,
    CREASE_ANGLE,
    DIFFUSE_COLOR,
    TRANSPARENCY,
    DRAW_STYLE,
    EMISSIVE_COLOR,
    FONT_NAME,
    FONT_SIZE,
    LIGHT_MODEL,
    LINE_PATTERN,
    LINE_WIDTH,
    MATERIAL_BINDING,
    POINT_SIZE,
    PICK_STYLE,
    PICK_METHOD,
    SHAPE_HINTS,
    SHININESS,
    SPECULAR_FACTOR,
    ROUGHNESS,
    METALLIC,
    SPECULAR_COLOR,
    POLYGON_OFFSET,
    PATTERN_OFFSET,
    FONT_RENDERSTYLE,
    FULL_SCENE_ANTIALIASING,
    TRANSPARENCY_TYPE,
    ENVIRONMENT,
    ENVIRONMENT_MAP,
    DEPTH_BUFFER_RANGE,
    DEPTH_BUFFER_FUNCTION,
    BBOX_TYPE,
    NEIGHBOR_TOLERANCE,
    TEXTPRP_ANTIALIASING_FACTOR,
    TEXTPRP_ALIGNEMENT_H,
    TEXTPRP_ALIGNEMENT_V,
    TEXTPRP_BACKFRAMELINE,
    TEXTPRP_ORIENTATION,
    TEXTPRP_KERNING,
    TEXTPRP_TEXTUREQUALITY,
    TEXTPRP_MARGIN,
    TEXTPRP_STYLE,
    TEXTPRP_STYLECOLORS,
    TEXTPRP_STYLECOLORS_USE_CURRENT_MATERIAL,
    TEXTPRP_CHARACTER_SPACING,
    LAST_OVERRIDE_BIT,
  };

  typedef std::bitset<LAST_OVERRIDE_BIT> BitSetType;

  // Initializes the SoOverrideElement class
  static void initClass();
  static void exitClass();

  /** Set specified flag */
  static void setOverrideFlag(SoState* state, SoNode* SO_UNUSED_PARAM(node), Defined_Override_Bit flag, bool override)
  {
    SO_SET_OVERRIDE(flag);
  }

  // Compares input SoOverrideElement with this object
  // possibly using testBitMask to filter some bits
  // returns true if all bits are set in both SoOverrideElement
  bool compareWithMask( const SoOverrideElement& in, const BitSetType* testBitMask = NULL ) const;

  // helper class to test several bit of the bitset without
  // getting the State element more than once
  class BitSetGetter
  {
    public:
    explicit BitSetGetter( SoState* state )
      : m_BufferedFlags( SoElement::getConstElement<SoOverrideElement>( state )->m_flags )
    {
    }

    virtual ~BitSetGetter()
    {
    }

    // this is not requiring the getConstElement that can be costly
    inline bool testBit( int i ) const
    {
      return m_BufferedFlags.test(i);
    }

    private:
      BitSetGetter & operator=( const BitSetGetter & ) { return *this; }
      const BitSetType& m_BufferedFlags;
  };

  // helper class to test several bit of the bitset without
  // getting the State element more than once
  class BitSetSetter
  {
  public:
    explicit BitSetSetter( SoState* state )
      : m_BufferedFlags( SoElement::getElement<SoOverrideElement>( state )->m_flags )
    {
    }

    virtual ~BitSetSetter()
    {
    }

    // this is not requiring the getConstElement that can be costly
    inline void setBit( size_t i, bool value )
    {
      m_BufferedFlags.set(i, value);
    }

  private:
    BitSetSetter & operator=( const BitSetSetter & );
    BitSetType& m_BufferedFlags;
  };

  /** Remove all override flag from the state */
  static void resetOverrideFlag(SoState* state);

 private:
  // Used by ::print method
  void pFlag(FILE *, int) const;

  BitSetType m_flags;

};

#endif /* _SO_OVERRIDE_ELEMENT */

