/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : P. ESTRADE (Nov 1999)
**=======================================================================*/

#pragma once

#include <Inventor/elements/SoReplacedElement.h>

/**
* @VSGEXT Stores current pattern value.
*
* @ingroup elements
*
*   @DESCRIPTION
*
*   @SEE_ALSO
*   SoPattern
*/

SoEXTENDER_Documented class INVENTOR_API SoPatternElement : public SoReplacedElement {
  SO_ELEMENT_HEADER( SoPatternElement );

 public:

  /**
   * Sets the current pattern attributes in the state
   */
  static void set(SoState* state, SoNode* node, SbString category, SbString name);

  /**
   * Gets the current pattern attributes in the state
   * pattern is NULL if no pattern has been set.
   * [OIV-WRAPPER-ARG IN,OUT,OUT,OUT&ARRAY{128}]
   */
  static void get(SoState* state, SbString& category, SbString& name, unsigned char*& pattern);

  /** Push copies the values from the previous element */
  virtual void  push(SoState *state);

  /**
   * Default values
   * [OIV-WRAPPER-ARG OUT,OUT,OUT&ARRAY{128}]
   */
  static void getDefault(SbString& category, SbString& name, unsigned char*& pattern);

protected:

  /** Initializes element */
  virtual void init(SoState* state);

  /** Returns TRUE if the attributes of pattern  match in both elements */
  virtual SbBool matches(const SoElement* elt) const;

  /** Create and return a copy of this element */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoPattern class
  static void initClass();
  static void exitClass();

 protected:
  SbString m_category;
  SbString m_name;
  unsigned char* m_pattern;

  virtual void setElt( SbString category, SbString name, unsigned char* pattern );

  virtual ~SoPatternElement() ;
};
