/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Dec 1998)
**=======================================================================*/

                                                             /* include files */
#ifndef  _SO_POLYGON_OFFSET_ELEMENT_
#define  _SO_POLYGON_OFFSET_ELEMENT_

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/SbEnums.h>

/**
* @VSGEXT Stores current polygon offset state.
*
* @ingroup elements
*
*   @DESCRIPTION
*
*   @SEE_ALSO
*   SoPolygonOffset
*/

SoEXTENDER_Documented class INVENTOR_API SoPolygonOffsetElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoPolygonOffsetElement) ;

 public:
   /** PolygonOffset style. */
  enum Style {
    /** FILLED */
    FILLED = SbEnums::OFFSET_SOLID,
    /** LINES */
    LINES  = SbEnums::OFFSET_WIREFRAME,
    /** POINTS */
    POINTS = SbEnums::OFFSET_WIREFRAME
  } ;

  /** Sets the current polygon offset attributes in the state */
  static void set(SoState *state, SoNode *node, float factor, float units, Style styles, SbBool on) ;
  /** Gets the current polygon offset attributes in the state */
  static void get(SoState *state, float &factor, float &units, Style &styles, SbBool &on) ;
  
  /** Push copies the values from the previous element */
  virtual void  push(SoState *state) ;

  /** Default values */
  static void getDefault(float &factor, float &units, Style &styles, SbBool &on) ;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /** Returns TRUE if the attributes of polygon offset  match in both elements */
  virtual SbBool matches(const SoElement* elt) const;

  /** Create and return a copy of this element */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoPolygonOffsetElement class
  static void initClass() ;
  static void exitClass() ;

 protected:
  float  m_factor ;
  float  m_units ;
  Style  m_stylesMask ;
  SbBool m_on ;

  virtual void setElt(float factor, float units, Style styles, SbBool on) ;

  virtual ~SoPolygonOffsetElement() ;
} ;

#endif /* _SO_POLYGON_OFFSET_ELEMENT_ */


