/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : Thad Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/
 

#ifndef  _SO_PROFILE_COORDINATE_ELEMENT
#define  _SO_PROFILE_COORDINATE_ELEMENT

#include <Inventor/SbBasic.h>
#include <Inventor/SbLinear.h>
#include <Inventor/elements/SoReplacedElement.h>

/**
*   Stores the current profile coordinates.
* 
* @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current profile coordinates, as either 2D or
*   3D points.
* 
*   This class allows read-only access to the top element in the state
*   to make accessing several values in it more efficient. Individual
*   values must be accessed through this instance.
* 
*   @SEE_ALSO
*   SoProfileCoordinate2, SoProfileCoordinate3
*/

SoEXTENDER_Documented class INVENTOR_API SoProfileCoordinateElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoProfileCoordinateElement);

 public:
  /**
   * Sets the current 2D profile coordinates.
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(coords != NULL? coords->Length: 0)},ARRAY]
   */
  static void         set2(SoState *state, SoNode *node,
                           int32_t numCoords, const SbVec2f *coords);
  /**
   * Sets the current 3D profile coordinates.
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(coords != NULL? coords->Length: 0)},ARRAY]
   */
  static void         set3(SoState *state, SoNode *node,
                           int32_t numCoords, const SbVec3f *coords);

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoProfileCoordinateElement * getInstance(SoState *state);

  /**
  *  Returns the number of coordinate points in an instance.
  */
  int32_t             getNum() const          { return numCoords; }

  /**
  *  Returns the indexed coordinate from an element as a
  *  2D vector, converting if necessary.
  */
  const SbVec2f &     get2(int index) const;
  /**
  *  Returns the indexed coordinate from an element as a 
  *  3D vector, converting if necessary.
  */
  const SbVec3f &     get3(int index) const;

  /**
  *  Returns the array of SbVec2f without any conversion. 
  *  The pointer may be NULL if coordinates are specified as 3D vectors.
  */
  const SbVec2f *     getCoord2() const { return coords2 ; }
  
  /**
  *  Returns the array of SbVec3f without any conversion. 
  *  The pointer may be NULL if coordinates are specified as 2D vectors.
  */
  const SbVec3f *     getCoord3() const { return coords3 ; }

  /**
  *  TRUE if set2() was called.
  */
  SbBool              is2D() const  { return coordsAre2D; }

  /**
  *  Returns the default 2D profile coordinate.
  */
  static SbVec2f      getDefault2() { return SbVec2f(0.0, 0.0); }
  /**
  *  Returns the default 3D profile coordinate.
  */
  static SbVec3f      getDefault3() { return SbVec3f(0.0, 0.0, 1.0); }

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoCoordinateElement class
  static void         initClass();
  static void         exitClass();

 protected:
  int32_t             numCoords;
  const SbVec2f       *coords2;
  const SbVec3f       *coords3;
  SbBool              coordsAre2D;

  virtual ~SoProfileCoordinateElement();

 private:
  static SbVec2f     *defaultCoord2;
  SbVec2f             convert2;       // To convert from 3-D to 2-D
  SbVec3f             convert3;       // To convert from 2-D to 3-D
};

#endif /* _SO_PROFILE_COORDINATE_ELEMENT */


