/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : G.TALLEC (May 2007)
**=======================================================================*/

#ifndef  _SO_PROJECTION_ELEMENT
#define  _SO_PROJECTION_ELEMENT

#include <Inventor/elements/SoElement.h>

#include <Inventor/misc/SoState.h>
#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/errors/SoDebugError.h>

class SbProjection;
class SoProjection;

/**
 * @VSGEXT Store current projection node.
 * 
 * @ingroup Element
 * 
 * @DESCRIPTION
 * 
 *  This element stores the current projection node. 
 *
 * @SEE_ALSO
 *   SoProjection
 * 
 * 
 */
SoEXTENDER class INVENTOR_API SoProjectionElement :public SoReplacedElement
{

  SO_ELEMENT_HEADER( SoProjectionElement );

public:

  /**
  *  Sets the current projection node in the state
  */
  static void set( SoState *state, SoProjection *prj );

  /**
  *  Sets the current projection node in the state
  */
  static void set( SoState *state, SoNode *, SoProjection *prj );

  /**
  *  Returns the current projection node from the state
  */
  static SoProjection *get( SoState *state );

  /**
  *  Returns the projection routine associated with current SoProjection node
  */
  static SbProjection *getInternalProjection( SoState *state );

protected:

  /** Initialize element : called by constructor. */
  virtual void commonInit();

  /** Initializes element. */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the projection are the same in both elements.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

  SoINTERNAL public:

  // Initializes the SoProjectionElement class
  static void initClass();
  static void exitClass();

protected:

  virtual void setProjection( SoProjection *projection );

  virtual ~SoProjectionElement();

private:
  // projection node
  SoProjection *m_projection;
  bool m_isOn;
};

#endif 


