/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Sep 2003)
**=======================================================================*/

#ifndef  _SO_REPLACED_TEXTURE_ELEMENT_
#define  _SO_REPLACED_TEXTURE_ELEMENT_

/**
*  @VSGEXT Abstract base class for each texture state element.
*
*  @ingroup elements
*
*   @DESCRIPTION
*   This is the abstract base class for each texture state element.
*   A node-id is associated to each texture unit.
*
*   Subclasses may need to override the push() method to copy values
*   from the next instance in the stack (using getNextInStack() ),
*   if the new one has to copy values (node-id) on top of the old ones.
*
*   This class defines the matches() method to compare lists of
*   node-id's associated to each texture unit.
*   The node-id's represent the states of all nodes that
*   changed the value of the element. SoReplacedTextureElement provides
*   methods that maintain lists of node-id's of all nodes that affect
*   an instance. Subclasses must call these methods to make sure the
*   id's are up to date, if they plan to use the standard matches()
*   method. Otherwise, they can define matches() differently, if they
*   wish.
*
*   @SEE_ALSO
*/

#include <Inventor/elements/SoSubElement.h>
#include <Inventor/STL/vector>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

SoEXTENDER_Documented class INVENTOR_API SoReplacedTextureElement : public SoElement {

  SO_ELEMENT_ABSTRACT_HEADER(SoReplacedTextureElement);

 public:

 /**
 *  Prints element (for debugging).
 */
 virtual void        print(FILE *fp) const;

  /**
  *  Pushes the element, copying values from previous element in
  *  state. node-ids associated to each texture unit are copied.
  */
  virtual void push(SoState *state) ;

protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

  /**
  * Returns TRUE if the element matches another element, based on node-id's.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  * Create and return a copy of this element; this will copy the
  * nodeId list properly.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoReplacedTextureElement class
  static void         initClass();
  static void         exitClass();

protected:
  // Overrides SoElement::getElement() to set the nodeId of the current
  // texture unit in the element instance before returning it.
  // static SoElement *getElement(SoState *state, int stackIndex, SoNode *node) ;
  static SoElement *getElement(SoState *state, SoType type, int stackIndex, SoNode *node) ;

  /**
   * [OIV-WRAPPER CUSTOM_CODE]
   */
  template<typename T>
  static T *getElement(SoState *state, int stackIndex, SoNode *node)
  {
    return static_cast<T*>(getElement(state, T::getClassTypeId(), stackIndex, node));
  }

  // Destructor
  virtual ~SoReplacedTextureElement();

  // Sets the id of the given node of the current texture unit
  void setNodeId(SoState *state, const SoNode *node);

  // return the nodeId for the given texture unit
  uint64_t& getNodeId(const int unit) const;

private:
  // This stores the list of node id's as pointers associated to
  // each texture unit.
  typedef std::vector<uint64_t> SoNodeIdList;
  mutable SoNodeIdList m_nodeIdList;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif /* _SO_REPLACED_TEXTURE_ELEMENT_ */


