/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_SPECULAR_COLOR_ELEMENT
#define  _SO_SPECULAR_COLOR_ELEMENT


#include <Inventor/SbColor.h>
#include <Inventor/misc/SoState.h>
#include <Inventor/elements/SoMaterialElement.h>
#include <Inventor/errors/SoDebugError.h>

/**
*   Stores specular color of current material (superseded by SoMaterialElement).
* 
*   @ingroup elements
*
*   @DESCRIPTION
*   This class is superseded by the SoMaterialElement class.
*   All methods are converted inline to SoMaterialElement methods for
*   compatibility. This only uses the first specular color, not an
*   array of them.
* 
*   @SEE_ALSO
*
* [OIV-WRAPPER-NO-WRAP]
*/

SoEXTENDER_Documented class SoDEPRECATED_CLASS(9500, "See #SoMaterialElement instead.") SoSpecularColorElement {


 public:

  /**
   * Sets the current specular color(s).
   * [OIV-WRAPPER-ARG IN,IN,NO_WRAP{(colors != NULL? colors->Length: 0)},ARRAY]
   */
  static void         set(SoState *state, SoNode *,
                          int32_t numColors, const SbColor *colors);

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoSpecularColorElement * getInstance(SoState *state);

  /**
  *  Returns the number of specular colors in any instance.
  */
  int32_t getNum() const
  { return 1; }

  /**
  *  Returns the current specular color.
  */
  const SbColor &  get(int index) const;

  /**
  *  Returns the default specular color.
  */
  static SbColor getDefault()         
  { return SoMaterialElement::getDefaultSpecular(); }
    
 private:
  SoState* saveState;
};

inline void
#if defined(_DEBUG)
SoSpecularColorElement::set(SoState *state, SoNode *node, int32_t numColors, const SbColor *colors)
#else
SoSpecularColorElement::set(SoState *state, SoNode *node, int32_t, const SbColor *colors)
#endif
{
  SoMaterialElement::setSpecular(state,node,*colors);
#if defined(_DEBUG)
  if(numColors>1){
    SoDebugError::post("SoSpecularColorElement::set",
                       "multiple specular colors not supported");
  }
#endif
}


inline const SoSpecularColorElement * 
SoSpecularColorElement::getInstance(SoState *state)
{
  SoSpecularColorElement* sce = new SoSpecularColorElement;
  sce->saveState = state;
  return(sce);
}

inline const SbColor &
#if defined(_DEBUG)
SoSpecularColorElement::get(int index) const
#else
SoSpecularColorElement::get(int ) const
#endif
{
#if defined(_DEBUG)
  if(index >1)
    SoDebugError::post("SoSpecularColorElement::get",
                       "multiple specular colors not supported");
#endif
  return(SoMaterialElement::getSpecular(saveState));
}

#endif /* _SO_SPECULAR_COLOR_ELEMENT */

