/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SUB_ELEMENT_
#define  _SO_SUB_ELEMENT_

#include <Inventor/elements/SoElement.h>

#if defined(_DEBUG)
#include <Inventor/SoDB.h>
#endif

/////////////////////////////////////////////////////////////////////////////
//
// Macros to be called within the class definition header for a element
// subclass:
//

////////////////////////////////////////////
//
// These define type-identifier and stack index variables and methods
// that all subclasses must support.
//

//
// This one is for abstract element classes.
//

#define SO_ELEMENT_ABSTRACT_HEADER(className)                                 \
  public:                                                                     \
    /** Returns the type identifier for this class.  */                       \
    static SoType       getClassTypeId();                                     \
    /** Returns the stack id for this element.                                \
    * [OIVJAVA-WRAPPER OBSOLETE{replaced by SoElement.getClassStackIndex(Class)},SINCE{9.3}]] \
    * [OIVNET-WRAPPER OBSOLETE]                                               \
    */                                                                        \
    static int          getClassStackIndex();                                 \
  SoINTERNAL public:                                                          \
     /** Returns the stack id for this element.  */                           \
    static SoElement::SoElementKeyType getClassElementKey();                  \
    virtual SoElement::SoElementKeyType getElementKey() const;                \
    virtual int         getClassStackIndexInternal() const;                   \
  protected:                                                                  \
    className();                                                              \
  private:                                                                    \
    static int         classStackIndex;                                       \
    static SoType      classTypeId;                                           \
    static SoElement::SoElementKeyType      s_classElementKey;

//
// This one is for non-abstract element classes.
//
#define SO_ELEMENT_HEADER(className)                                          \
    SO_ELEMENT_ABSTRACT_HEADER(className);                                    \
  private:                                                                    \
    static void *createInstance(SoType* dynamicType = NULL)

/////////////////////////////////////////////////////////////////////////////
//
// Macros to be called within the source file for a element subclass:
//

////////////////////////////////////////////
//
// This declares the static variables defined in SO_ELEMENT_HEADER
// or SO_ELEMENT_ABSTRACT_HEADER.
//

#define SO__ELEMENT_ABSTRACT_VARS(className)                                  \
  SoType  className::classTypeId;                         \
  int className::classStackIndex = 0;                     \
  SoElement::SoElementKeyType className::s_classElementKey = SoElement::badElementKey();

#define SO__ELEMENT_VARS(className)                                           \
SO__ELEMENT_ABSTRACT_VARS(className)

#if defined(_DEBUG)
#define SO_ELEMENT_CHECK_INIT(className) { \
  if (classTypeId.isBad()) { \
    SoDebugError::post("Element Constructor", \
                       "Can't construct an element of type " \
                       SO__QUOTE(className) \
                       " until initClass() has been called"); \
    className::initClass(); \
  } \
  SoTypedObject::checkDatabase(SO__QUOTE(className), this, className::getClassTypeId(), classTypeId); \
}
#else
#define SO_ELEMENT_CHECK_INIT(className) { \
  if (classTypeId.isBad()) { \
    className::initClass(); \
  } \
}
#endif

//
// Methods on an abstract type
//
#define SO__ELEMENT_ABSTRACT_METHODS(className)                               \
                                                                              \
className::className()                                                        \
{                                                                             \
  SO_ELEMENT_CHECK_INIT(className);                                    \
  commonInit() ;                                                              \
}                                                                             \
                                                                              \
SoType                                                                        \
className::getClassTypeId()                                                   \
{                                                                             \
  return classTypeId;                                                         \
}                                                                             \
                                                                              \
int                                                                           \
className::getClassStackIndex()                                               \
{                                                                             \
  return classStackIndex;                                                     \
}                                                                             \
                                                                              \
int                                                                           \
className::getClassStackIndexInternal() const                                 \
{                                                                             \
return className::classStackIndex;                                            \
}                                                                             \
                                                                              \
SoElement::SoElementKeyType                                                   \
className::getClassElementKey()                                               \
{                                                                             \
return className::s_classElementKey;                                          \
}                                                                             \
                                                                              \
SoElement::SoElementKeyType                                                   \
className::getElementKey() const                                              \
{                                                                             \
return className::s_classElementKey;                                          \
}



//
// Methods on a non-abstract type
//
#define SO__ELEMENT_METHODS(className)                                        \
                                                                              \
className::className()                                                        \
{                                                                             \
    SO_ELEMENT_CHECK_INIT(className);                                  \
    commonInit() ;                                                            \
    setTypeId(classTypeId);                                                   \
    setStackIndex(classStackIndex);                                           \
}                                                                             \
                                                                              \
void *                                                                        \
className::createInstance(SoType *)                                           \
{                                                                             \
  return new className;                                                       \
}                                                                             \
                                                                              \
SoType                                                                        \
className::getClassTypeId()                                                   \
{                                                                             \
  return classTypeId;                                                         \
}                                                                             \
                                                                              \
int                                                                           \
className::getClassStackIndex()                                               \
{                                                                             \
  return classStackIndex;                                                     \
}                                                                             \
                                                                              \
int                                                                           \
className::getClassStackIndexInternal() const                                 \
{                                                                             \
return className::classStackIndex;                                            \
}                                                                             \
                                                                              \
SoElement::SoElementKeyType                                                   \
className::getClassElementKey()                                               \
{                                                                             \
  return className::s_classElementKey;                                        \
}                                                                             \
                                                                              \
SoElement::SoElementKeyType                                                   \
className::getElementKey() const                                              \
{                                                                             \
   return className::s_classElementKey;                                       \
}


/////////////////////////////////////////////
//
// These include all the definitions required
// at file scope
//

#define SO_ELEMENT_ABSTRACT_SOURCE(className)                                 \
    SO__ELEMENT_ABSTRACT_VARS(className);                                     \
    SO__ELEMENT_ABSTRACT_METHODS(className)

#define SO_ELEMENT_SOURCE(className)                                          \
    SO__ELEMENT_VARS(className);                                              \
    SO__ELEMENT_METHODS(className)

////////////////////////////////////////////
//
// This initializes the type identifer variables defined in
// SO_ELEMENT_HEADER or SO_ELEMENT_ABSTRACT_HEADER. This macro
// should be called from within initClass(). The parentClass argument
// should be the class that this subclass is derived from.
//
#if defined(_DEBUG)
#define SO_ELEMENT_INIT_CLASS_CHECK_PARENT(className, parentClass)                   \
  if (parentClass::getClassTypeId().isBad()) {                                        \
    SoDebugError::post( SO__QUOTE(className)"::initClass",                            \
      SO__QUOTE(className)" initialized before parent class " \
      SO__QUOTE(parentClass)"\n");                                                    \
    parentClass::initClass();                                                         \
  }
#else
#define SO_ELEMENT_INIT_CLASS_CHECK_PARENT(className, parentClass)                   \
  if (parentClass::getClassTypeId().isBad())                                          \
    parentClass::initClass()
#endif

#define SO_ELEMENT_INIT_ABSTRACT_CLASS_INTERNAL(className,parentClass) \
    SO_ELEMENT_INIT_CLASS_CHECK_PARENT(className, parentClass); \
    classTypeId = SoType::createType( parentClass::getClassTypeId(), \
                                      SO__QUOTE(className), \
                                      NULL); \
    classStackIndex = parentClass::getClassStackIndex(); \
    if(s_classElementKey == SoElement::badElementKey()) \
      s_classElementKey = createElementKey();

#define SO_ELEMENT_INIT_ABSTRACT_CLASS(className, parentClass) \
  SO_ELEMENT_INIT_ABSTRACT_CLASS_INTERNAL(className, parentClass);

#define SO_ELEMENT_INIT_CLASS_INTERNAL(className,parentClass) \
    SO_ELEMENT_INIT_CLASS_CHECK_PARENT(className, parentClass); \
    classTypeId = SoType::createType( parentClass::getClassTypeId(), \
                                      SO__QUOTE(className), \
                                      &className::createInstance); \
    if (classStackIndex == 0) \
    { \
      if (parentClass::getClassStackIndex() < 0) \
        classStackIndex = createStackIndex(classTypeId); \
      else \
        classStackIndex = parentClass::getClassStackIndex(); \
    } \
    if(s_classElementKey == SoElement::badElementKey()) \
      s_classElementKey = createElementKey();

#define SO_ELEMENT_INIT_CLASS(className, parentClass) \
  SO_ELEMENT_INIT_CLASS_INTERNAL(className, parentClass);

#if defined(_DEBUG)
#define SO_ELEMENT_EXIT_CLASS(className) \
  if (! SoType::removeType(classTypeId.getName())) { \
    SoDebugError::post(SO__QUOTE(className)"::exitClass", \
                       "Unable to remove type (%s) for this class. Check exitClass() " \
                       "method is implemented and is called only once.\n", \
                       classTypeId.getName().getString() ); \
  } \
  else { \
    classTypeId = SoType::badType(); \
    classStackIndex = 0; \
  }
#else
#define SO_ELEMENT_EXIT_CLASS(className) \
  SoType::removeType(classTypeId.getName()); \
  classTypeId = SoType::badType(); \
  classStackIndex = 0
#endif

#endif /* _SO_SUB_ELEMENT_ */


