/*=================================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
***                                                                            ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
***                                                                            ***
***                        RESTRICTED RIGHTS LEGEND                            ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
***                                                                            ***
***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                    ***
***                              BORDEAUX, FRANCE                              ***
***                            ALL RIGHTS RESERVED                             ***
=================================================================================*/

#pragma once

#include <Inventor/SbVertexAttributeBinding.h>
#include <Inventor/elements/SoInt32Element.h>

/**
 * Stores current tangent binding.
 *
 * @ingroup elements
 *
 * @DESCRIPTION
 * This element stores the current tangent binding.
 *
 * @SEE_ALSO
 * SoTangentBinding, SoVertexProperty
 */
SoEXTENDER_Documented class INVENTOR_API SoTangentBindingElement : public SoInt32Element
{
  SO_ELEMENT_HEADER( SoTangentBindingElement );

public:
 /**
  * The choice of values is for compatibility
  * with Open Inventor 2.0 binary format files:
  */
  enum Binding
  {
    /**
     * Whole object has same tangent.
     */
    OVERALL = SbVertexAttributeBinding::OVERALL,
    /**
     * One tangent for each part of object.
     */
    PER_PART = SbVertexAttributeBinding::PER_PART,
    /**
     * One tangent for each part, indexed.
     */
    PER_PART_INDEXED = SbVertexAttributeBinding::PER_PART_INDEXED,
    /**
     * One tangent for each face of object.
     */
    PER_FACE = SbVertexAttributeBinding::PER_FACE,
    /**
     * One tangent for each face, indexed.
     */
    PER_FACE_INDEXED = SbVertexAttributeBinding::PER_FACE_INDEXED,
    /**
     * One tangent for each vertex.
     */
    PER_VERTEX = SbVertexAttributeBinding::PER_VERTEX,
    /**
     * One tangent for each vertex, indexed.
     */
    PER_VERTEX_INDEXED = SbVertexAttributeBinding::PER_VERTEX_INDEXED
  };

  /**
   * Sets the current tangent binding in the state.
   */
  static void set( SoState* state, Binding binding )
  {
    SoInt32Element::set( getClassTypeId(), classStackIndex, state, static_cast<int32_t>(binding) );
  }

  /**
   * Sets the current tangent binding in the state.
   */
  static void set( SoState* state, SoNode*, Binding binding )
  {
    set( state, binding );
  }

  /**
   * Returns current tangent binding from the state.
   */
  static Binding get( SoState* state )
  {
    return static_cast<Binding>( SoInt32Element::get( getClassTypeId(), classStackIndex, state ) );
  }

  /**
   * Returns the default tangent binding.
   */
  static Binding getDefault()
  {
    return PER_VERTEX_INDEXED;
  }

  /**
   * Prints element (for debugging).
   */
  virtual void print( FILE* fp ) const;

protected:
  /** Initializes element */
  virtual void init( SoState* state );

SoINTERNAL public:
  // Initializes the SoTangentBindingElement class
  static void initClass();
  static void exitClass();

protected:
  virtual ~SoTangentBindingElement();
};
