/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Nov 2004)
**=======================================================================*/

#ifndef  _SO_TEXT_ALIGNMENTV_ELEMENT_
#define  _SO_TEXT_ALIGNMENTV_ELEMENT_

#include <Inventor/elements/SoInt32Element.h>

/**
*  @VSGEXT  Stores the current vertical text alignment.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current vertical text alignment.
*
*   @SEE_ALSO
*   SoTextProperty
*/
SoEXTENDER_Documented class INVENTOR_API SoTextAlignmentVElement : public SoInt32Element {

  SO_ELEMENT_HEADER(SoTextAlignmentVElement);

 public:

    /** AlignmentV */
   enum AlignmentV {
    /** TOP */
    TOP    = 0x01,
    /** HALF */
    HALF   = 0x03,
    /** BASE */
    BASE   = 0x04,
    /** BOTTOM */
    BOTTOM = 0x05
  };

  /**
  *  Sets the current vertical text alignment in the state.
  */
  static void set(SoState *state, AlignmentV style);

  /**
  *  Sets the current vertical text alignment in the state.
  */
  static void set(SoState *state, SoNode *, AlignmentV style) { set(state, style); }

  /**
  *  Returns current draw style from the state.
  */
  static AlignmentV get(SoState *state) { return (AlignmentV)SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default draw style.
  */
  static AlignmentV getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoTextAlignmentVElement class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoTextAlignmentVElement();
};

#endif // _SO_TEXT_ALIGNMENTV_ELEMENT_

/**/


