/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (July 2012)
**=======================================================================*/

#ifndef  _SO_TEXT_BACKFRAME_LINE_WIDTH_ELEMENT_
#define  _SO_TEXT_BACKFRAME_LINE_WIDTH_ELEMENT_

#include <Inventor/elements/SoFloatElement.h>


/**
*  @VSGEXT Stores the current text backFrame line width.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current text backFrame line width value.
*   The width value is a 1/40 factor of the current font size for SoText3 nodes,
*   and is a pixel value for the SoText2 nodes.
*
*   @SEE_ALSO
*   SoTextProperty
*/
SoEXTENDER_Documented class INVENTOR_API SoTextBackFrameLineWidthElement : public SoFloatElement
{

  SO_ELEMENT_HEADER(SoTextBackFrameLineWidthElement);

 public:

   /**
   *  Sets the current horizontal text backFrame width in the state.
   */
   static void set(SoState *state, float width);

   /**
   *  Sets the current horizontal text backFrame width in the state.
   */
  static void set(SoState* state, SoNode*, float width) { set(state, width); }

  /**
  *  Returns current draw style from the state.
  */
  static float get(SoState* state) { return SoFloatElement::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default draw style.
  */
  static float getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:

  // Initializes the SoTextBackFrameLineWidthElement class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoTextBackFrameLineWidthElement();

 private:
  static float s_defaultBackFrameLineWidth;
  static bool s_isSet;
};

#endif // _SO_TEXT_BACKFRAME_LINE_WIDTH_ELEMENT_

/**/


