/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Aug 2009)
**=======================================================================*/

#ifndef  SO_TEXT_EFFECTS_ELEMENT
#define  SO_TEXT_EFFECTS_ELEMENT

#include <Inventor/elements/SoInt32Element.h>

/**
* @VSGEXT Stores the current text effect settings.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current text effects settings.
*
*   @SEE_ALSO
*   SoTextProperty
*/

SoEXTENDER_Documented class INVENTOR_API SoTextStyleElement : public SoInt32Element
{

  SO_ELEMENT_HEADER(SoTextStyleElement);

 public:
    /**
    *  Available styles (may be combined):
    */
    enum Style
    {
      /** No effects. */
      NONE                  = 1 << 0,
      /** UNDERLINE */
      UNDERLINE             = 1 << 1,
      /** STRIKETHROUGH */
      STRIKETHROUGH         = 1 << 2,
      /** DOUBLE_STRIKETHROUGH */
      DOUBLE_STRIKETHROUGH  = 1 << 3,
      /** BACK_FRAME */
      BACK_FRAME            = 1 << 4,
      /** BACK_FRAME_LINE */
      BACK_FRAME_LINE       = 1 << 5,      
      /** OVERLINE */
      OVERLINE              = 1 << 6
    };

    /**
     *  Sets the current style type in the state.
     */
     static void set(SoState *state, Style style);

    /**
     *  Sets the current style type in the state.
     */
  static void set(SoState *state, SoNode *, Style style)
    { set(state, style); }

  /**
  *  Returns current style from the state.
  */
  static Style get(SoState *state)
    { return (Style)SoInt32Element::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default style.
  */
  static Style getDefault();

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoComplexityTypeElement class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoTextStyleElement();
};

#endif // SO_TEXT_EFFECTS_ELEMENT


