/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : Thad Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_COORDINATE_BINDING_ELEMENT
#define  _SO_TEXTURE_COORDINATE_BINDING_ELEMENT

#include <Inventor/SbVertexAttributeBinding.h>
#include <Inventor/elements/SoReplacedTextureElement.h>
#include <Inventor/STL/vector>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

/**
*  Stores the current 3D texture coordinates.
* 
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current texture coordinate binding.
* 
*   @SEE_ALSO
*   SoTextureCoordinateBinding
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureCoordinateBindingElement : public SoReplacedTextureElement {
  
  SO_ELEMENT_HEADER(SoTextureCoordinateBindingElement);
  
 public:
 /**
 *  The choice of values is for compatibility
 *  with Open Inventor 2.0 binary format files.
 */
 enum Binding {
  /**
  *  Per vertex texture coordinates
  */
  PER_VERTEX = SbVertexAttributeBinding::PER_VERTEX,
  /**
  *  Per vertex, indexed, texture coordinates
  */
  PER_VERTEX_INDEXED = SbVertexAttributeBinding::PER_VERTEX_INDEXED
  };
    

  /**
  *  Sets the current texture binding in the state.
  */
  static void   set(SoState *state, Binding binding) ;
    
  /**
  *  Sets the current texture binding in the state.
  */
  static void   set(SoState *state, SoNode *, Binding binding) ;
    
  /**
  *  Returns current texture binding from the state.
  */
  static Binding      get(SoState *state, int unit=0) ;
    
  /**
  *  Returns the default texture binding.
  */
  static Binding      getDefault()
    { return PER_VERTEX_INDEXED; }

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void push(SoState *) ;
    
  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;
    
protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the SoTextureCoordinateBindingElement class
  static void         initClass();
  static void         exitClass();

protected:
  virtual ~SoTextureCoordinateBindingElement();
    
 private:

   Binding& getBinding(const size_t unit) const;

   mutable std::vector<Binding> m_coordBinding ;
};

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif /* _SO_TEXTURE_COORDINATE_BINDING_ELEMENT */


