/*=================================================================================
 ***     THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),    ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
 ***                                                                            ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
 ***                                                                            ***
 ***                        RESTRICTED RIGHTS LEGEND                            ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
 ***                                                                            ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                    ***
 ***                              BORDEAUX, FRANCE                              ***
 ***                            ALL RIGHTS RESERVED                             ***
 =================================================================================*/

#ifndef  _SO_TEXTURE_CUBEMAP_ENABLED_ELEMENT
#define  _SO_TEXTURE_CUBEMAP_ENABLED_ELEMENT

#include <Inventor/elements/SoReplacedTextureElement.h>
#include <Inventor/STL/vector>

/**
 * @VSGEXT Enables/disables textureCubeMap.
 *
 * @ingroup elements
 *
 *   @DESCRIPTION
 *   This element enables/disables textureCubeMap. This is implemented as a
 *   separate element from the TextureImageElement so the texture image
 *   can be changed without invalidating caches containing shapes-- shapes
 *   need to know if texturing is going on or not so they can decide to
 *   send down texture coordinates or not.
 *
 *   This element is very similar to SoTextureEnabledElement but contrary to
 *   SoTextureImageElement, we can't deal with the texture2D and the CubeMap
 *   texture in the same element.
 *
 *   This element cannot be overridden, but, since the elements that
 *   set it check each other's value, overriding those elements has
 *   the same effect.
 *
 *   @SEE_ALSO
 *   SoTextureCubeMap, SoTextureEnabledElement, SoTexture3EnabledElement
 */
class INVENTOR_API SoTextureCubeMapEnabledElement : public SoReplacedTextureElement
{

  SO_ELEMENT_HEADER( SoTextureCubeMapEnabledElement );

public:
  /**
   *  Used by GLTextureImageElement, set to TRUE when a non-null
   *  image is set, set to FALSE when there is no texture image (the
   *  default).
   */
  static void set( SoState* state, SbBool value, SoNode* node = NULL );

  /**
   *  Used by shapes to figure out if they need to send texture
   *  coordinates.
   */
  static SbBool get( SoState* state, int unit = 0 );

  /**
   *  By default there is no texture.
   */
  static SbBool getDefault() { return FALSE; }

  /**
   *  Overrides push() so we can remember previous elements value and
   *  avoid making GL calls if this element has the same value.
   */
  virtual void push( SoState* state );

  /**
   *  Overrides pop() method so side effects can occur in GL.
   */
  virtual void pop( SoState* state, const SoElement* prevTopElement );

  /**
  * Specify that a texture unit is not used by any shape, so we don't have to invalidate cache when this texture is enable/disable/modified
  */
  static void disableForShapeCache( SoState* state, int unit, bool disable );

  /**
  * Return if that texture unit is not used by any shape, so we don't have to invalidate cache when this texture is enable/disable/modified
  */
  static bool isDisabledForShapeCache( SoState* state, int unit );

SoINTERNAL public:
  // Initializes the SoTextureCubeMapEnabledElement class
  static void         initClass();
  static void         exitClass();

  virtual ~SoTextureCubeMapEnabledElement();

protected:

  /**
   *  Common Initialization. Directly called by the constructor.
   */
  virtual void commonInit();

  /** Initializes element */
  virtual void init( SoState* state );

  // Indicates for each texture unit if the textureCubeMap is enabled.
  bool getEnableFlag(const size_t unit) const;

private:

  // Indicates for each texture unit if texturing is enabled.
  mutable std::vector<SbBool> m_enable;

  // Indicates for each texture init if this texture will be disable in shape cache system
  mutable std::vector<int> m_textureDisableForShapeCache;
};

#endif /* _SO_TEXTURE_CUBEMAP_ENABLED_ELEMENT */


