/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Patrick Vigneras (Nov 1999)
**=======================================================================*/

#ifndef  _SO_TEXTURE_IMAGE3_ELEMENT
#define  _SO_TEXTURE_IMAGE3_ELEMENT

#include <Inventor/SbColor.h>
#include <Inventor/elements/SoTextureImageElementBase.h>
#include <Inventor/sys/SoGLType.h>

class SoBufferObject;
class SoGLTexture;

/**
*  @VSGEXT Stores the current 3D texture image.
* 
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current 3D texture image.
* 
*   @SEE_ALSO
*   SoTexture3
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureImage3Element : public SoTextureImageElementBase {

  SO_ELEMENT_HEADER(SoTextureImage3Element);

public:

  /** 
   * Gets the current image, wrap, and model.
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{size.Value[0]*size.Value[1]*size.Value[2]*numComponents}]
   */
  static const unsigned char *get(SoState *state, SbVec3s &size,
                                  int &numComponents, int &wrapS,
                                  int &wrapT, int &wrapR, int &model, 
                                  SbColor &blendColor, int unit=0);

  /**
  *  Pass texname = -1 to deactivate subtexturing. subtexturing not active
  *  by default. In any case, the regular set method must be called.
  */
  static void             set(SoState *state, SoNode *node,
                              const SbVec3s &subSize, int xoffset, int yoffset, int zoffset,
                              const unsigned char *bytes, int texname) ;
  /**
  *  Returns the default texture image.
  * [OIV-WRAPPER-RETURN-TYPE ARRAY{s.Value[0]*s.Value[1]*s.Value[2]*nc}]
  */
  static const unsigned char *getDefault(SbVec3s &s, int &nc);

  /**
   *  Returns TRUE if the texture contains transparency info.
   */
  static SbBool       containsTransparency(SoState *state, int unit=0);

protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

  /** Initializes element. */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the class
  static void         initClass();
  static void         exitClass();

  /** Helper function to set various parameters */
  static void set(SoState *state, SoNode *node, const SoTexImageData& parameters);

  /** Sets the current image, wrap, and model.*/
  static void set(SoState *state, SoNode *node,
                  const SbVec3s &size, int numComponents,
                  const unsigned char *bytes,
                  SoBufferObject* bufferObject,
                  GLint GLInternalFormat,
                  int wrapS, int wrapT, int wrapR, int model,
                  const SbColor &blendColor,float maxAnisotropy,
                  SbBool enableBorder, const SbVec4f &borderColor);

protected:
  /** [OIV-WRAPPER NO_WRAP] */
  virtual void        setElt(const SbVec3s &s, int nc,
                             const unsigned char *bytes,
                             SoBufferObject* bufferObject,
                             GLint GLInternalFormat,
                             int wrapS, int wrapT, int wrapR, int model,
                             const SbColor &blendColor, float _maxAnisotropy,
                             SbBool _enableBorder, const SbVec4f &_borderColor,
                             int unit=0);
        
  virtual void        setSubElt(const SbVec3s &subSize,
                                int xoffset, int yoffset, int zoffset,
                                const unsigned char *bytes, int texname,
                                int unit=0);

  virtual ~SoTextureImage3Element();
};

#endif /* _SO_TEXTURE_IMAGE3_ELEMENT */


