/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_QUALITY_ELEMENT
#define  _SO_TEXTURE_QUALITY_ELEMENT

#include <Inventor/elements/SoFloatElement.h>
#include <Inventor/SoPreferences.h>

/**
*  Stores the current texture quality.
*
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current texture quality.
*
*   @SEE_ALSO
*   SoShapeHints
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureQualityElement : public SoFloatElement {

  SO_ELEMENT_HEADER(SoTextureQualityElement);

 public:
  /**
  *  Sets the current texture quality in the state.
  */
  static void         set(SoState *state, float qual)
  { SoFloatElement::set(getClassTypeId(), getClassStackIndex(), state, qual); }

  /**
  *  Returns current texture quality from the state.
  */
  static float        get(SoState *state)
    { return SoFloatElement::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default texture quality.
  */
  static float  getDefault()                    { return SoPreferences::getFloat ("OIV_TEXTURE_QUALITY", 0.5); }

  /** Returns TRUE if element has been set in set. */
  static bool isSetInState(SoState *state);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Comparison based on value of floats
  */
  virtual SbBool matches(const SoElement* elt) const;

  /** Copy method, takes care copying the data. */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoTextureQualityElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTextureQualityElement();

  /** Sets the current complexity in the state. */
  virtual void setElt(float value);

  bool m_isSetInState;
};

/**
*  Stores the current texture override.
*
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores a flag for each type of element which can be
*   overridden.  Nodes implement override by setting the appropriate
*   bit if their override flag is on, and ignoring overridden elements
*   if the corresponding bit in the state's SoTextureOverrideElement is set.
*
*   @SEE_ALSO
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureOverrideElement : public SoElement {

  SO_ELEMENT_HEADER(SoTextureOverrideElement);

  enum {
    TEXTURE_QUALITY = 0x1,
    TEXTURE_IMAGE   = 0x2
  };

 public:

  /**
  *  Overrides push() method to copy values from next instance in
  *  the stack, and set up cache dependencies correctly.
  */
  virtual void        push(SoState *state);

  //
  // "get" methods for each element which can be overridden.
  //

  /**
  *  Returns TRUE iff SoTextureQualityElement is overridden.
  */
  static SbBool       getQualityOverride(SoState *state);

  /**
  *  Returns TRUE iff SoTextureImageElement is overridden.
  */
  static SbBool       getImageOverride(SoState *state);

  //
  // "set" methods for each element which can be overridden.
  //

  /**
  *  Sets override flag for SoTextureQualityElement.
  */
  static void         setQualityOverride(SoState *state,
                                         SbBool override);

  /**
  *  Sets override flag for SoTextureImageElement.
  */
  static void         setImageOverride(SoState *state,
                                       SbBool override);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Comparison based on value of int32_ts.
  */
  virtual SbBool      matches(const SoElement *elt) const;

  /** @copydoc SoElement::copyMatchInfo() */
  virtual SoElement   *copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoTextureOverrideElement class
  static void         initClass();
  static void         exitClass();

 private:
  // Used by ::print method
  void pFlag(FILE *, const char *, int) const;

  uint32_t flags;
};

#endif /* _SO_TEXTURE_QUALITY_ELEMENT */


