/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (Nov 2001)
**=======================================================================*/

#ifndef  _SO_TEXTURE_SENDING_ENABLED_ELEMENT_
#define  _SO_TEXTURE_SENDING_ENABLED_ELEMENT_
/* include files */
#include <Inventor/elements/SoInt32Element.h>

/*----------------------------------------------------------------------------*/

/**
*  @VSGEXT Stores the information that indicates if texture calls must be sent.
* 
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores information that indicates if texture calls must be sent.
* 
*   @SEE_ALSO
*/
SoEXTENDER_Documented class INVENTOR_API SoTextureSendingEnabledElement : public SoInt32Element {

  SO_ELEMENT_HEADER(SoTextureSendingEnabledElement);

 public:
  /**
  *  Sets the current element value.
  */
  static void    set(SoState *state, SbBool flag);

  /**
  *  Returns the current element value.
  */
  static SbBool  get(SoState *state);

  /**
  *  Returns the default element value.
  */
  static SbBool   getDefault()         { return TRUE; }

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  // Initializes the  class
  static void    initClass();
  static void    exitClass();

 protected:
  virtual ~SoTextureSendingEnabledElement();
};

/*----------------------------------------------------------------------------*/

#endif /* _SO_TEXTURE_SENDING_ENABLED_ELEMENT_ */


