/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_TRANSFORM_ELEMENT
#define  _SO_TEXTURE_TRANSFORM_ELEMENT

#include <Inventor/elements/SoReplacedTextureElement.h>
#include <Inventor/STL/vector>

class SoTexture2Transform;
class SoNode ;

/**
*  @VSGEXT Stores the current texture transform.
* 
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current texture transform.
* 
*   @SEE_ALSO
*   SoCallbackAction
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureTransformElement : public SoReplacedTextureElement {

  SO_ELEMENT_HEADER(SoTextureTransformElement);

 public:
  /**
  *  Sets the current texture name.
  */
  static void         set(SoState *state, SoNode *node);

  /**
  *  Returns the current texture name from the state.
  */
  static const SoTexture2Transform *  get(SoState *state, int unit=0);

  /**
  *  Returns the default texture name.
  */
  static SbName       getDefault()    { return NULL; }

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void        push(SoState *state);

protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

 SoINTERNAL public:
  // Initializes the SoTextureNameElement class
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoTextureTransformElement();

 private:
  SoNode*& getTextureTransformNode(const int unit) const;
  mutable std::vector<SoNode*> m_textureTransform;
};

#endif /* _SO_TEXTURE_TRANSFORM_ELEMENT */


