/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_VERTEX_SHADER_PARAMETER_ELEMENT_
#define  _SO_VERTEX_SHADER_PARAMETER_ELEMENT_

/* include files */
#include <Inventor/SoLists.h>
#include <Inventor/elements/SoAccumulatedElement.h>

class SoVertexShaderParameter;

/**
*   @VSGEXT Stores SoVertexShaderParameter nodes encountered during traversal.
* 
*   @ingroup elements
*
*   @DESCRIPTION
*   This element stores SoVertexShaderParameter nodes encountered during traversal.
*
*   @SEE_ALSO
*   SoShaderParameter
*/

SoEXTENDER_Documented class INVENTOR_API SoVertexShaderParameterElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER(SoVertexShaderParameterElement);

 public:
  /**
  *  Add to the current vertex attribs list.
  */
  static void add(SoState *state, SoVertexShaderParameter * vertexAttrib);
  
  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void push(SoState *state);

  /**
  *  Pop method.
  */
  virtual void pop(SoState *, const SoElement *prevTopElement);
  
  /**
  *  Returns the current list of vertex attribs nodes from the state.
  */
  static const SoNodeList * getVertexAttribs(SoState *state);

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

 SoINTERNAL public:
  
  // Initializes the SoLightElement class
  static void initClass();
  static void exitClass();
 
 protected:
  // list of light nodes
  SoNodeList m_vertexAttribs;

  virtual ~SoVertexShaderParameterElement();
};
/*----------------------------------------------------------------------------*/

#endif // _SO_VERTEX_SHADER_PARAMETER_ELEMENT_


