/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_VIEWPORT_REGION_ELEMENT
#define  _SO_VIEWPORT_REGION_ELEMENT

#include <Inventor/SbBasic.h>
#include <Inventor/SbViewportRegion.h>
#include <Inventor/elements/SoSubElement.h>

/**
*   Stores the current viewport region.
* 
*   @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current viewport region, which indicates
*   which part of the window is being rendered into. This information
*   is also needed during picking and bounding box computation to
*   determine sizes/locations of screen-space objects.
* 
*   @SEE_ALSO
*   PoBaseView, SoGetBoundingBoxAction, SoGetMatrixAction, SoGLRenderAction,
*   SoHandleEventAction, SoRayPickAction, SoCamera
*/

SoEXTENDER_Documented class INVENTOR_API SoViewportRegionElement : public SoElement {

  SO_ELEMENT_HEADER(SoViewportRegionElement);

 public:
  /**
  *  Sets the viewport region.
  *  This method will (indirectly) call glViewport with the new values
  *  unless the 'sendToGL' parameter is explicitly FALSE.
  */
  static void         set(SoState *state,
                          const SbViewportRegion &vpReg, SbBool sendToGL = TRUE);

  /**
  *  Returns current viewport region from the state.
  */
  static const SbViewportRegion & get(SoState *state);

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the viewports match.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  static void setViewportRegionNoPush( SoState* state, const SbViewportRegion& vpReg );

  // Initializes the SoViewportRegionElement class
  static void         initClass();
  static void         exitClass();

 protected:
  SbViewportRegion    viewportRegion;

  // Sets the region in an instance
  virtual void        setElt(const SbViewportRegion &vpReg, SbBool sendToGL = TRUE);

  virtual ~SoViewportRegionElement();

 private:
  static SbViewportRegion *emptyViewportRegion;
};

#endif /* _SO_VIEWPORT_REGION_ELEMENT */


