/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Alain Dumesny (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_WINDOW_ELEMENT
#define  _SO_WINDOW_ELEMENT

#include <Inventor/elements/SoSubElement.h>
#include <Inventor/helpers/SbGlContextHelper.h>

class SoGLRenderAction;

/**
*   Stores the current window attributes.
*
*   @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current window attributes. The current window
*   is defined as the OpenGL window underneath the cursor - or NULL if the
*   cursor is not over an OpenGL window.
*
*   @SEE_ALSO
*   SoWinRenderArea, SoXtRenderArea, SoQtRenderArea
*/

#ifdef OIV_HEADLESS
/**
* [OIV-WRAPPER-CLASS NO_WRAP]
*/
#endif
SoEXTENDER_Documented class INVENTOR_API SoWindowElement : public SoElement
{

  SO_ELEMENT_HEADER(SoWindowElement);

 public:

  /**
   * Reset the element to default values.
   * @M_SINCE 9.1
   */
  static void reset(SoState *state);

  // Sets the window, context, and glRenderAction info
#ifdef _WIN32
  /**
  *  Under Windows, the types are actually:
  *  Window     = HWND
  *  GLXContext = HGLRC
  *  Display    = HDC
  *
  *  So why don't we just use those types?
  *  In non-MFC Win32 programs, these types are all "void *",
  *  but MFC redefines these types to "struct _something *".
  *  So if we used HWND etc here, the mangled names would not
  *  match for MFC programs.  Better to just force void*.
  *
  *  Note: The fourth argument is "Display".  On Windows we
  *        don't normally use this for anything, but here it
  *        is convenient to use it to store the window's DC,
  *        since that value is needed to call SbGlContextHelper::makeCurrent.
  */
  static void set(SoState *state, void *window, void *context, void *display, SoGLRenderAction *glAction);

#elif defined __APPLE__
#else
  /**
  *  Sets the window, context, and glRenderAction info.
  */
  static void set(SoState *state, Window window, SbGlContextHelper::GLContext context, SbGlContextHelper::Display display, SoGLRenderAction *glAction);
#endif

#ifdef _WIN32
  /**
  *  Returns the current window, context, and glRenderAction.
  */
  static void get(SoState *state, void *&window, void *&context,
                  void *&display, SoGLRenderAction *&glAction);

#elif defined __APPLE__
#else
  /**
  *  Returns the current window, context, and glRenderAction.
  */
  static void get(SoState *state, Window &window, SbGlContextHelper::GLContext &context,
                  SbGlContextHelper::Display &display, SoGLRenderAction *&glAction);
#endif

  /**
    *  Sets the window, context, and glRenderAction info.
    */
  static void set(SoState *state, SbGlContextHelper::Drawable window, SbGlContextHelper::GLContext context, SbGlContextHelper::Display display, const SoGLRenderAction *glAction);
    
  /**
   *  Returns the current window, context, and glRenderAction.
   */
  static void get(SoState *state, SbGlContextHelper::Drawable &window, SbGlContextHelper::GLContext &context,
                  SbGlContextHelper::Display &display, const SoGLRenderAction*& glAction);
  
  /**
   *  Returns the current glRenderAction.
   */
  static SoGLRenderAction* getAction(SoState *state);

  /**
  *  Push.
  */
  virtual void push(SoState *state);

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Always returns TRUE, since this element should never be a
  *  criterion for cache invalidation.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public:
  // Initializes the SoWindowElement class
  static void initClass();
  static void exitClass();

protected:

  SbGlContextHelper::GLContext context;
  SbGlContextHelper::Drawable window;
  SbGlContextHelper::Display display;
  SoGLRenderAction* glRenderAction;

  virtual ~SoWindowElement();
};

#endif /* _SO_WINDOW_ELEMENT */


