/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_BOOL_OPERATION_
#define  _SO_BOOL_OPERATION_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoMFEnum.h>
#include <Inventor/fields/SoMFBool.h>

/**
 * Performs Boolean operations.
 * 
 * @ingroup engines
 * 
 * @DESCRIPTION
 *   This engine performs a Boolean operation on two inputs, and returns both the
 *   result of the operation and its inverse.
 *   
 *   The input fields can have multiple values, allowing the engine to perform several
 *   Boolean operations in parallel. One input may have more values than the other.
 *   In that case, the last value of the shorter input will be repeated as necessary.
 * 
 * @FILE_FORMAT_DEFAULT
 *    BoolOperation {
 *    @TABLE_FILE_FORMAT
 *       @TR a           @TD FALSE
 *       @TR b           @TD FALSE
 *       @TR operation   @TD A
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoEngineOutput,
 *    SoCalculator
 * 
 * 
 */
class INVENTOR_API SoBoolOperation : public SoEngine {

  SO_ENGINE_HEADER(SoBoolOperation);
    
 public:

   /** Operation */
  enum Operation {
    /** Clear */
    CLEAR,
    /** Set */
    SET,
    /** A */
    A,
    /** Not A */
    NOT_A,
    /** B */
    B,
    /** Not B */
    NOT_B,
    /** A or B */
    A_OR_B,
    /** Not A or B */
    NOT_A_OR_B,
    /** A or not B */
    A_OR_NOT_B,
    /** Not A or not B */
    NOT_A_OR_NOT_B,
    /** A and B */
    A_AND_B,
    /** Not A and B */
    NOT_A_AND_B,
    /** A and not B */
    A_AND_NOT_B,
    /** Not A and not B */
    NOT_A_AND_NOT_B,
    /** A equals B */
    A_EQUALS_B,
    /** A not equals B */
    A_NOT_EQUALS_B
  };

  /**
   * First argument to the Boolean operation. 
   */
  SoMFBool    a;
  /**
   * Second argument to the Boolean operation. 
   */
  SoMFBool    b;
  /**
   * The Boolean operation. 
   */
  SoMFEnum    operation;
    
  /**
   * ( SoMFBool )  Result of the Boolean operation applied to the inputs.
   */
  SoEngineOutput output;
  /**
   * ( SoMFBool )  Inverse of output.
   */
  SoEngineOutput inverse;
    
  /**
   * Constructor.
   */
  SoBoolOperation();
    
 SoINTERNAL public:

  static void initClass();
  static void exitClass();


 protected:
  // Destructor
  ~SoBoolOperation();

  // Evaluation method
  virtual void evaluate();
};

#endif  /* _SO_BOOL_OPERATION_ */

