/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_CONCATENATE_
#define  _SO_CONCATENATE_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFName.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoConcatenate
//
//  Concatenate several fields together into one big field.
//
//////////////////////////////////////////////////////////////////////////////

class SoMField;

/**
* Joins separate fields into a single multiple-value field.
* 
* @ingroup engines
* 
* @DESCRIPTION
*   This engine joins up to 10 separate fields of a type into a single
*   multiple-valued field of the same type. The type of the input fields can be any
*   subclass of SoMField The type is specified when an instance of the class is
*   created. For example, SoConcatenate( \if_cpp SoMFFloat::getClassTypeId() \endif 
*   \if_dotnet typeof(SoMFFloat) \endif \if_java SoMFFloat.getClass() \endif ) creates an
*   engine that concatenates floating-point values.
*   
*   The @B input @b field is a 10-element array, where each element can be connected
*   to single- or multiple-valued fields. All the values in the input are
*   concatenated together to form one multiple-value field. For example, if
*   @B input[0] @b contains 10 values and @B input[1] @b contains 3 values, the
*   output will contain 13 values.
*   
*   Note that by default @B input @b does not contain any values, and no value is
*   output from the engine.
*   \if_cpp
*   Note also that, unlike the output of most engines, #output is a pointer. 
*   \endif
* 
* @FILE_FORMAT_DEFAULT
*    Concatenate {
*    @TABLE_FILE_FORMAT
*       @TR type     @TD \<inputType\>
*       @TR input0   @TD []
*       @TR input1   @TD []
*       @TR input2   @TD []
*       @TR input3   @TD []
*       @TR input4   @TD []
*       @TR input5   @TD []
*       @TR input6   @TD []
*       @TR input7   @TD []
*       @TR input8   @TD []
*       @TR input9   @TD []
*    @TABLE_END
*    }
* 
* @SEE_ALSO
*    SoEngineOutput,
*    SoGate,
*    SoSelectOne
* 
* [OIVNET-WRAPPER-CLASS SEALED]
*/ 
class INVENTOR_API SoConcatenate : public SoEngine {
  
  SO_ENGINE_HEADER(SoConcatenate);
  
 public:
  /**
   * Constructor. The argument specifies the type of values to concatenate.
   */
  SoConcatenate(SoType mfInputType);

  /**
   * Array of Input.
   * Connect them like this:
   *    concatenate->input[0]->connectFrom(...)
   * The names of these inputs is input0 ... input9.
   * The default value for these fields is no values.
   */
  SoMField *input[10];
  
  /**
   * Output.
   * Is of the same type as the inputs (note that it is a pointer, unlike most engine outputs).
   */
  SoEngineOutput *output;
  
 SoINTERNAL public:
  // Initializes engine class
  static void initClass();
  static void exitClass();

  // Copies an instance that is encountered through a field connection
  virtual SoFieldContainer *copyThroughConnection() const;
  
 protected:
  ~SoConcatenate();

 private:
  // Constructor/Destructor.  This constructor is used only when
  // reading these from file.
  SoConcatenate();
  
  // Concatenate engines must write out their input type before writing
  // their fields, so these are overridden:
  virtual SbBool readInstance(SoInput *in, unsigned short flags);
  virtual void writeInstance(SoOutput *out);
  
  void setup(SoType);
  virtual void evaluate();
  
  int conversionCase;
  
  SoFieldData *myInputData;
  SoEngineOutputData *myOutputData;
  
  SoSFName typeField; // Used when reading/writing
};

#endif /* _SO_CONCATENATE_ */

