/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_ONE_SHOT_
#define  _SO_ONE_SHOT_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFTrigger.h>
#include <Inventor/fields/SoSFTime.h>
#include <Inventor/fields/SoSFBitMask.h>

/**
 * Timer that runs for a pre-set amount of time.
 * 
 * @ingroup engines
 * 
 * @DESCRIPTION
 *   This engine is a timer that runs for a pre-set amount of time and then stops. By
 *   default, the #timeIn input is connected to the @B realTime @b global
 *   field. It can, however, by connected to any other time source.
 *   
 *   The timer is started when the #trigger input is touched. It then runs for
 *   the specified #duration, and updates the #timeOut output with the
 *   time that has elapsed. During that time, the #ramp output is also updated.
 *   The #ramp output starts at 0.0 at the beginning of the cycle, and linearly
 *   increases until it reaches 1.0 at the end of the cycle.
 *   
 *   You can disable the timer by setting the #disable input to TRUE. The output
 *   value remains 0.0 while the timer is disabled. If the timer is disabled in the
 *   middle of a cycle the output values will be set to 0.0.
 *   
 *   The #flags input contains control flags. Using the flags you can set the
 *   timer to be retriggerable in the middle of a cycle, and set the output values to
 *   stay high after the cycle has been completed. By default, these flags are not
 *   set.
 * 
 * @FILE_FORMAT_DEFAULT
 *    OneShot {
 *    @TABLE_FILE_FORMAT
 *       @TR duration   @TD 1
 *       @TR trigger    @TD 
 *       @TR flags      @TD ()
 *       @TR disable    @TD FALSE
 *       @TR timeIn     @TD \<current time\>
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoElapsedTime,
 *    SoEngineOutput
 * 
 * 
 */
class INVENTOR_API SoOneShot : public SoEngine {

  SO_ENGINE_HEADER(SoOneShot);

 public:
  
   /** Flags */
  enum Flags {
    /** Can start over during the cycle */
    RETRIGGERABLE   = (1<<0),       
    /** Output values stay high after cycle */
    HOLD_FINAL      = (1<<1)
  };

  /**
   * Duration of the active cycle. 
   */
  SoSFTime            duration;
  /**
   * Start the cycle. The trigger will be ignored if it is touched in the middle of a
   * cycle and the RETRIGGERABLE flag is not set. 
   */
  SoSFTrigger         trigger;
  /**
   * Control flags. 
   */
  SoSFBitMask         flags;
  /**
   * If TRUE, the timer is disabled. 
   */
  SoSFBool            disable;
  /**
   * Running time. 
   */
  SoSFTime            timeIn;

  /**
   * ( SoSFTime )  Elapsed time from the start.
   */
  SoEngineOutput      timeOut;
  /**
   * ( SoSFBool )  Is TRUE during the active cycle.
   */
  SoEngineOutput      isActive;
  /**
   * ( SoSFFloat )  Ramps linearly from 0.0 to 1.0.
   */
  SoEngineOutput      ramp;

  /**
   * Constructor
   */
  SoOneShot();

 SoINTERNAL public:

  static void initClass();
  static void exitClass();
  
  // Writes instance to SoOutput. Takes care of not writing out
  // connection to realTime that is created in constructor.
  virtual void        writeInstance(SoOutput *out);

 protected:
  virtual void        inputChanged(SoField *whichInput);

  // Evaluation method
  virtual void        evaluate();

  // Reads stuff into instance.  Works around a problem with old
  // files that contain explicit references to the default
  // connection to realTime.
  virtual SbBool      readInstance(SoInput *in, unsigned short flags);

  // Destructor
  ~SoOneShot();
 private:
  enum State {
    DISABLED,               // everything clamped at 0 (via disable input)
    OFF,                    // normal idle state
    TRIGGERED,              // has been triggered, need to start running
    ON,                     // running, watching the time
    PEAKED                  // have reached the end, need to reset
  }                   state;
  SbTime              baseTime;       // Starting time for elapsed time 
  SbTime              timeVal;        // holds output time value
  double              rampVal;        // holds ramp value
  SbBool              outputPending;  // keeps outputs enabled until data is read



  ///////////////////////EXCEPTION METHODS/////////////////////////////////////
  //
  // #unfound enum Flags
  //
  /////////////////////////////////////////////////////////////////////////////

};

#endif  /* _SO_ONE_SHOT_ */

