/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TRANSFORM_VEC3F_
#define  _SO_TRANSFORM_VEC3F_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoMFMatrix.h>
#include <Inventor/fields/SoMFVec3f.h>

/**
 * Transforms a 3D vector by a 4x4 matrix.
 * 
 * @ingroup engines
 * 
 * @DESCRIPTION
 *   This engine takes as input a three dimensional floating-point vector and a
 *   transformation matrix. The vector is assumed to be a row vector.
 *   
 *   The engine multiplies the vector by the matrix and returns the result in the
 *   output #point. The output #direction contains the result when the
 *   matrix multiplication assumes the vector is a direction, and therefore ignores
 *   the translation part of the matrix. The output #normalDirection contains
 *   the normalized #direction
 * 
 * @FILE_FORMAT_DEFAULT
 *    TransformVec3f {
 *    @TABLE_FILE_FORMAT
 *       @TR vector         @TD 0 0 0
 *       @TR matrix         @TD 1 0 0 0
 *       @TR                @TD 0 1 0 0
 *       @TR                @TD 0 0 1 0
 *       @TR                @TD 0 0 0 1
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoEngineOutput
 * 
 * 
 */
class INVENTOR_API SoTransformVec3f : public SoEngine {

  SO_ENGINE_HEADER(SoTransformVec3f);
    
 public:

  /**
   * Input row vector. 
   */
  SoMFVec3f   vector;
  /**
   * Input transformation matrix. 
   */
  SoMFMatrix  matrix;
    
  /**
   * ( SoMFVec3f )  Vector transformed by matrix.
   */
  SoEngineOutput point;
  /**
   * ( SoMFVec3f )  Vector transformed by matrix, ignoring translation.
   */
  SoEngineOutput direction;
  /**
   * ( SoMFVec3f )  Normalized direction.
   */
  SoEngineOutput normalDirection;
    
  /**
   * Constructor
   */
  SoTransformVec3f();
    
 SoINTERNAL public:

  static void initClass();
  static void exitClass();

 protected:
  // Destructor
  ~SoTransformVec3f();
 
  // Evaluation method
  virtual void evaluate();
};

#endif  /* _SO_TRANSFORM_VEC3F_ */

