/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MOUSEWHEEL_EVENT_
#define  _SO_MOUSEWHEEL_EVENT_

#include <Inventor/SbBasic.h>
#include <Inventor/SbLinear.h>
#include <Inventor/events/SoSubEvent.h>


/**
 * Mouse wheel events.
 * 
 * @ingroup events
 * 
 * @DESCRIPTION
 * SoMouseWheelEvent represents a change in mouse wheel rotation event
 * in the Open Inventor event model.
 *
 * The wheel has discrete, evenly spaced notches. When you rotate the
 * wheel, a wheel message is sent as each notch is encountered. Most
 * modern mouse wheels generate an event with a value of 120 per each
 * notch of the wheel. Pressing the shift
 * key while moving the mouse wheel will generate events of double
 * the wheel delta (i.e., 240 by default). If necessary, you can use environment
 * variable OIV_WHEEL_DELTA to change this value (see SoPreferences).
 *
 * The #getDelta() method returns the distance that the mouse wheel
 * has been rotated. A positive value indicates the wheel was rotated
 * forward (away from the user); a negative value indicates the wheel
 * was rotated backwards (toward the user). The values are specified 
 * in multiples of the wheel delta.
 * 
 * @B NOTE:@b Wheel delta values are NOT always +/- 120.  In the case of wheel delta values
 * in a browser, i.e. using RemoteViz, the base delta value seems to be scaled by
 * the Windows Zoom level.  E.g. with Windows 7 and Chrome, when using the
 * default/typical "Medium" setting, the zoom level is 125% and the browser returns
 * 125% * 120 = 150. It is safe to use the sign of the value (positive or negative).
 * 
 * @SEE_ALSO
 *    SoEvent,
 *    SoButtonEvent,
 *    SoKeyboardEvent,
 *    SoMotion3Event,
 *    SoMouseButtonEvent,
 *    SoSpaceballButtonEvent,
 *    SoHandleEventAction,
 *    SoEventCallback,
 *    SoSelection,
 *    SoInteraction,
 *    SoWinDevice,
 *    SoMouseWheelEvent
 * 
 * 
 */
class INVENTOR_API SoMouseWheelEvent : public SoEvent {

  SO_EVENT_HEADER();
    
 public:
  
  /**
   * Constructor.
   */
  SoMouseWheelEvent();

  /** Sets the mouse wheel delta. 
   */
  void                setDelta(int delta)  { m_delta = delta; }

  /**
   * Gets the mouse wheel delta.
   */
  int  getDelta() const   { return m_delta; }


#ifndef HIDDEN_FROM_DOC
  virtual ~SoMouseWheelEvent();
#endif // HIDDEN_FROM_DOC
    
 SoINTERNAL public:
  static void     initClass();
  static void exitClass();
  int   getDefaultDelta();
  int   SO_WHEEL_DELTA;
 private:
   int m_delta;
};


#endif /* _SO_MOUSEWHEEL_EVENT_ */

