/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MF_COLORRGBA_
#define  _SO_MF_COLORRGBA_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbColorRGBA.h>
#include <Inventor/fields/SoMFVec4f.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoMFColorRGBA subclass of SoMField.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Multiple-value field containing any number of RGBA colors stored as four floats.
* 
* @ingroup fields
* 
* @DESCRIPTION
*   A multiple-value field that contains any number of RGBA colors, stored as instances 
*   of SbColorRGBA. RGBA stands for red, green, blue and alpha.  Values should be in
*   the range 0 to 1.  Alpha is the inverse of "transparency", in other words 0 is 
*   fully transparent and 1 is fully opaque.
*
*   Values can also be specified or queried in the HSV (hue, saturation and value)
*   color space, but values are stored internally as RGBA values.
*   
*   SoMFColorRGBAs are written to file as one or more RGBA quadruples of floating point
*   numbers in standard scientific notation. When more than one value is present,
*   all of the values are enclosed in square brackets and separated by commas. For
*   example:
*   
*   \verbatim
     [ 1.0 0.0 0.0 0.5, 0 1 0 1, 0 0 1 .25 ]
    \endverbatim
*    represents the three colors half transparent red, fully opeque green,
*    and one quarter transparent blue.
*   
*   
*   @B Data copying:@b
*   \par
*   SoMF fields are a kind of "smart container", automatically expanding as necessary
*   to hold the data provided by the application. This is very convenient, but for large
*   blocks of data it may be desireable to avoid making a copy of the application data.
*   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
*   methods allow Open Inventor to directly use an array of values supplied by the application.
*   The application data is not copied.  Please see SoMFVec3f for more information and example code.
* 
* @SEE_ALSO
*    SbColorRGBA
* 
* 
*/
class INVENTOR_API SoMFColorRGBA : public SoMField {
  // Use standard field stuff
  SO_MFIELD_HEADER(SoMFColorRGBA, SbColorRGBA, const SbColorRGBA &);
  
  SO_MFIELD_SETVALUESPOINTER_HEADER(float);
    
    public:
  //
  // Additional convenience functions
  //
  
  /**
   * \if_java
   * Sets RGBA values from the specified array of floats.
   * Each float should be in the range 0.0 to 1.0, and size of the array
   * must be a multiple of 4.
   * \else
   * Sets @B num@b RGBA values from an array of arrays of 4 floats.
   * Each float should be in the range 0.0 to 1.0, and there must be 4*@B num@b
   * total float values.
   * \endif
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN]
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSetValues(start, num)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{(num)},IN]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = rgba != null ? rgba.length/4 : 0; onSetValues(start, num)}]
   */ 
  void setValues(int start, int num, const float rgba[][4]);

  /**
   * Sets @B num@b HSV (hue, saturation and value) plus Alphe color values from an
   * array of arrays of 4 floats.
   * Each float should be in the range 0.0 to 1.0, and there must be 4*@B num@b
   * total float values.
   * [OIV-WRAPPER-CUSTOM-CODE]
   */ 
  void setHSVAValues(int start, int num, const float hsva[][4]);

  /** 
   * Sets the field to contain one and only one value, 
   * the given color (expressed as RGBA floating point values
   * in the range 0.0 to 1.0), and deletes the second and subsequent
   * values.
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */ 
  void setValue(const SbVec4f &vec);

  /** 
   * Sets the field to contain one and only one value, 
   * the given color (expressed as RGBA floating point values
   * in the range 0.0 to 1.0), and deletes the second and subsequent
   * values.
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */ 
  void setValue(float r, float g, float b, float a);
  
  /** 
   * Sets the field to contain one and only one value, 
   * the given color (expressed as an array of RGBA floating point values
   * in the range 0.0 to 1.0), and deletes the second and subsequent
   * values.
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */ 
  void setValue(const float rgba[4]);
  
  /** 
   * Sets the field to contain one and only one value, 
   * the given color (expressed as HSV plus Alpha floating point values
   * in the range 0.0 to 1.0), and deletes the second and subsequent
   * values.
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */ 
  void setHSVAValue(float h, float s, float v, float a);
  
  /** 
   * Sets the field to contain one and only one value, 
   * the given color (expressed as an array of HSV plus Alpha floating point values
   * in the range 0.0 to 1.0), and deletes the second and subsequent
   * values.
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */ 
  void setHSVAValue(const float hsva[4]);

  /** 
   * Sets one of N RGBA colors from SbVec4f. 
   * The array will be expanded and filled with zeros as necessary.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */ 
  void set1Value(int index, const SbVec4f &vec);
  
  /** 
   * Sets one of N RGBA colors from 4 floats.
   * The array will be expanded and filled with zeros as necessary.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN,IN,IN]
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */ 
  void set1Value(int index, float r, float g, float b, float a);
  
  /** 
   * Sets one of N RGBA colors from an array of 4 floats.
   * The array will be expanded and filled with zeros as necessary.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */ 
  void set1Value(int index, const float rgba[4]);
  
  /** 
   * Sets one of N HSV plus Alpha colors from 4 floats.
   * The array will be expanded and filled with zeros as necessary.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN,IN,IN]
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */ 
  void set1HSVAValue(int index, float h, float s, float v, float a);

  /**
   * Sets one of N HSV plus Alpha colors from an array of 4 floats.
   * The array will be expanded and filled with zeros as necessary.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER HELPER_BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */ 
  void set1HSVAValue(int index, const float hsva[4]);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();
 
 private:

};

#endif /* _SO_MF_COLORRGBA_ */

