/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MF_STRING_
#define  _SO_MF_STRING_

#include <Inventor/fields/SoSubField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoMFString subclass of SoMField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Multiple-value field containing any number of strings.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A multiple-value field that contains any number of strings.
 *   
 *   SoMFStrings are written to file as one or more strings within double quotes. Any
 *   characters (including newlines) may appear within the quotes. To include a
 *   double quote character within the string, precede it with a backslash. For
 *   example:
 *   
 *   \verbatim
      [ cowEnizer , "Scene Boy" , "He said, \"I did not!\"" ]
     \endverbatim
 *    
 * Unicode Support
 * 
 *    Unicode is an industry standard for encoding text of all forms and 
 *    languages for use by computers. Open Inventor supports Unicode 
 *    encoding, which allows internationalization of text in a standard 
 *    cross-platform fashion. 
 *      
 *    String and as well as classes like SoSFString 
 *    support the wchar_t type which is used for Unicode 
 *    strings, and all of the text nodes are able to render Unicode 
 *    strings.
 *
 *    SbString includes methods for construction of Unicode strings,
 *    string operators (=, += ,== ,!=, <, >, <=, >=), as well as a
 *    query method (SbString::isUnicode()).
 * 
 *    To be able to display a particular Unicode character, the 
 *    selected font must have a character for that Unicode value. Many
 *    fonts do not contain a complete set of Unicode characters.
 *    However, the shareware Unicode font file "Code2000" seems to work 
 *    well. 
 *  
 *    Note that Unicode characters are not directly supported in 
 *    Open Inventor files. Unicode strings are written as if the bytes in
 *    the string were a string of 8-bit characters. The string will be 
 *    prefixed by "MCS_U_". 
 * 
 *
 *   @B Data copying:@b
 *   \par
 *   SoMF fields are a kind of "smart container", automatically expanding as necessary
 *   to hold the data provided by the application. This is very convenient, but for large
 *   blocks of data it may be desireable to avoid making a copy of the application data.
 *   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
 *   methods allow Open Inventor to directly use an array of values supplied by the application.
 *   The application data is not copied.  Please see SoMFVec3f for more information and example code.
 * 
 */
class INVENTOR_API SoMFString : public SoMField {

  // Use standard field stuff
  SO_MFIELD_HEADER(SoMFString, SbString, const SbString &);
  SO_MFIELD_SETVALUESPOINTER_HEADER(SbString);
    
    public:
  //
  // Some additional convenience functions:
  //

  /**
   * Sets @B num @b values, starting at index @B start @b, to the strings in the
   * given character arrays.
   * [OIV-WRAPPER-NOT-WRAP]
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE void  setValues(int start, int num, const char *strings[]);

  /**
   * Deletes all values currently in this field and sets this field to contain only
   * the given string.
   * [OIV-WRAPPER-NOT-WRAP]
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE void  setValue(const char *string);

  /**
   * Sets @B num @b values, starting at index @B start @b, to the strings in the
   * given character arrays.
   * [OIV-WRAPPER-NOT-WRAP]
   */
  void  setValues(int start, int num, const SO_WCHAR_T *strings[]);

  /**
   * Deletes all values currently in this field and sets this field to contain only
   * the given string.
   * [OIV-WRAPPER-NOT-WRAP]
   */
  void  setValue(const SO_WCHAR_T *string);

  /**
   * Convenience function to delete text from consecutive strings.
   * All text from the given character of one line (fromChar in
   * fromLine) to the given character of another line (toChar in
   * toLine), inclusive, is deleted. Any leftover text on fromLine
   * and toLine is merged into one line.
   */
  void  deleteText(int fromLine, int fromChar, int toLine, int toChar);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  void checkUnicode(int index);

};

#endif /* _SO_MF_STRING_ */

