/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_MF_VEC3I32_
#define  _SO_MF_VEC3I32_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>

/**
* 
* @VSGEXT Multiple-value field containing any number of three-dimensional vectors.
* 
* @ingroup fields
* 
* @DESCRIPTION
*   A multiple-value field that contains any number of three-dimensional vectors,
*   each vector component being an integer.
*   
*   SoMFVec3i32 are written to file as one or more triples of integer values
*   separated by whitespace.
*   
*   When more than one value is present, all of the values are enclosed in square
*   brackets and separated by commas; for example:
*   
*   \verbatim
     [ 0 0 0, 1 4 6, 9 -4 2 ]
    \endverbatim
*   
*   @B Data copying:@b
*   \par
*   SoMF fields are a kind of "smart container", automatically expanding as necessary
*   to hold the data provided by the application. This is very convenient, but for large
*   blocks of data it may be desireable to avoid making a copy of the application data.
*   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
*   methods allow Open Inventor to directly use an array of values supplied by the application.
*   The application data is not copied.  Please see SoMFVec3f for more information and example code.
* 
*/
class INVENTOR_API SoMFVec3i32 : public SoMField {
  // Use standard field stuff
  SO_MFIELD_HEADER(SoMFVec3i32, SbVec3i32, const SbVec3i32 &);

  SO_MFIELD_SETVALUESPOINTER_HEADER(int32_t);
  SO_MFIELD_SETVALUESPOINTER_HEADER(SbVec3i32);
  SO_FIELD_SUPPORT_MEMOBJ();

    public:
  
  //
  // Some additional convenience functions:
  //
  /**
   * \if_java
   * Sets values from the specified array of integers.
   * The size of the array must be a multiple of 3.
   * \else
   * Sets values from array of arrays of 3 integers.
   * \endif
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, num)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{(num)},IN]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = xyz != null ? xyz.length/3 : 0; onSetValues(start, num)}]
   */
  void setValues(int start, int num, const int32_t xyz[][3]);
#ifdef _WIN32
  /**
  * Need overload to work around MS compiler bug (fixed in VC++ 5.0)
  * [OIV-WRAPPER-NO-WRAP]
  */
  void  setValues(int start, int num,       int32_t xyz[][3]);
#endif
 
  /**
   * Sets one value from 3 integers.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void  set1Value(int index, int32_t x, int32_t y, int32_t z);
  
  /**
   * Sets one value from 3 integers in array.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void  set1Value(int index, const int32_t xyz[3]);
  
  /**
   * Sets to one value from 3 integers.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void  setValue(int32_t x, int32_t y, int32_t z);
  
  /**
   * Sets to one value from 3 integers in array.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void  setValue(const int32_t xyz[3]);

  /**
   * Sets one value from single precision vector.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, const SbVec3f &vec3f);
  
  /**
   * Sets one value from double precision vector.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void  set1Value(int index, const SbVec3d &vec3d);

  /**
   * Sets to one value from single precision vector.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(const SbVec3f &vec3f);
  
  /**
   * Sets to one value from double precision vector.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void  setValue(const SbVec3d &vec3d);
  
  /**
   * Sets values from array of single precision vectors.
   * [OIVNET-WRAPPER-ARG INDEX{0,},NO_WRAP{vec3f->Length},ARRAY]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, vec3f->Length)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{num},ARRAY]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = vec3f != null ? vec3f.length : 0; onSetValues(start, num)}]
   */
  void setValues(int start, int num, const SbVec3f *vec3f);

  /**
   * Sets values from array of double precision vectors.
   * [OIVNET-WRAPPER-ARG INDEX{0,},NO_WRAP{vec3d->Length},ARRAY]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, vec3d->Length)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{num},ARRAY]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = vec3d != null ? vec3d.length : 0; onSetValues(start, num)}]
   */
  void  setValues(int start, int num, const SbVec3d *vec3d);
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();
  virtual void writeBinaryValues(SoOutput*, int , int ) const;
  virtual SbBool readBinaryValues( SoInput*, int, int );

 private:
  // Write the values out as a block of data
  virtual void writeBinaryValues(SoOutput *out) const;
  virtual SbBool readBinaryValues(SoInput *in, int numToRead);

};

#endif /* _SO_MF_VEC3I32_ */


