/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_MF_VEC4S_
#define  _SO_MF_VEC4S_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoMFVec4s subclass of SoMField.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Multiple-value field containing any number of four-dimensional vectors.
* 
* @ingroup fields
* 
* @DESCRIPTION
*   A multiple-value field that contains any number of four-dimensional vectors.
*   
*   SoMFVec4ss are written to file as one or more quadruplets of short values
*   separated by whitespace. When more than one value is present, all of the values
*   are enclosed in square brackets and separated by commas; for example:
*   
*   \verbatim
     [ 0 0 0 0, 1 3 8 4, 100 17 52 38]
    \endverbatim
*   
*   @B Data copying:@b
*   \par
*   SoMF fields are a kind of "smart container", automatically expanding as necessary
*   to hold the data provided by the application. This is very convenient, but for large
*   blocks of data it may be desireable to avoid making a copy of the application data.
*   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
*   methods allow Open Inventor to directly use an array of values supplied by the application.
*   The application data is not copied.  Please see SoMFVec3f for more information and example code.
* 
* 
*/
class INVENTOR_API SoMFVec4s : public SoMField {
  // Use standard field stuff
  SO_MFIELD_HEADER(SoMFVec4s, SbVec4s, const SbVec4s &);
  
  SO_MFIELD_SETVALUESPOINTER_HEADER(short);
  SO_MFIELD_SETVALUESPOINTER_HEADER(SbVec4s);

  SO_FIELD_SUPPORT_MEMOBJ();

    public:
  //
  // Some additional convenience functions:
  //
  
  /**
   * \if_java
   * Sets values from the specified array of shorts.
   * The size of the array must be a multiple of 4.
   * \else
   * Sets values from array of arrays of 4 shorts.
   * \endif
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, num)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{(num)},IN]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = xyzw != null ? xyzw.length/4 : 0; onSetValues(start, num)}]
   */
  void setValues(int start, int num, const short xyzw[][4]);
  
  /**
   * Sets one value from 4 shorts.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN,IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, short x, short y, short z, short w);
  
  /**
   * Sets one value from 4 shorts in array.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, const short xyzw[4]);
  
  /**
   * Sets to one value from 4 shorts.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(short x, short y, short z, short w);
  
  /**
   * Sets to one value from 4 shorts in array.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(const short xyzw[4]);
  
  /**
   * Sets one value from single precision vector.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, const SbVec4f &vec4f);
  
  /**
   * Sets to one value from single precision vector.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(const SbVec4f &vec4f);
  
  /**
   * Sets values from array of single precision vectors.
   * [OIVNET-WRAPPER-ARG IN,NO_WRAP{(vec4f != NULL? vec4f->get_Length(): 0)},ARRAY]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, vec4f != NULL? vec4f->get_Length(): 0)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{(num)},ARRAY]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = vec4f != null ? vec4f.length : 0; onSetValues(start, num)}]
   */
  void setValues(int start, int num, const SbVec4f *vec4f);
  
 SoINTERNAL public:
  static void   initClass();
  static void exitClass();
  virtual void writeBinaryValues(SoOutput*, int , int ) const;
  virtual SbBool readBinaryValues( SoInput*, int, int );

private:
  virtual void writeBinaryValues(SoOutput *out) const;
  virtual SbBool readBinaryValues(SoInput *in, int numToRead);

};

#endif /* _SO_MF_VEC4S_ */


