/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_ENGINE_
#define  _SO_SF_ENGINE_

class SoEngine;

#include <Inventor/fields/SoSubField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFEngine subclass of SoSField. The field value is a pointer to an
//  SoEngine. The field automatically maintains a reference to the engine
//  it points to and propagates notification from the engine.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Field containing an engine instance.
* 
* @ingroup fields
* 
* @DESCRIPTION
*   This field maintains an SoEngine instance\if_cpp , correctly maintaining
*   its reference counts \endif\.
*   
*   SoSFEngines are written to file as the engine they are maintaining. For
*   example:
*   
*   \verbatim
     mySoSFEngineField ElapsedTime
    \endverbatim
*    is an SoSFEngine field named 'mySoSFEngineField', containing an
*   SoElapsedTime engine. If the engine is used elsewhere, the regular DEF/USE
*   instancing mechanism applies:
*   
*   \verbatim
     anotherSoSFEngineField USE calculator
    \endverbatim
*    is an SoSFEngine field that refers to a engine named 'calculator' that
*   was DEF'ed earlier in the scene.
* 
* @SEE_ALSO
*    SoField,
*    SoSField,
*    SoMFEngine,
*    SoEngine
* 
* 
*/
class INVENTOR_API SoSFEngine : public SoSField {

  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFEngine, SoEngine *, SoEngine *);

 SoINTERNAL public:
  static void         initClass();
  static void exitClass();

  // Update a copied field to use the copy of the engine if there is one
  virtual void        fixCopy(SbBool copyConnections);

  // Override this to also check the stored engine
  virtual SbBool      referencesCopy() const;

 private:
  // Override this to maintain write-references in engine
  virtual void        countWriteRefs(SoOutput *out) const;

  // Changes value in field without doing other notification stuff.
  // Keeps track of references and auditors.
  void                setVal(SoEngine *newValue);

};

#endif /* _SO_SF_ENGINE_ */

