/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Oct 2006)
**=======================================================================*/


#ifndef  _SO_SF_FILE_PATH_STRING_
#define  _SO_SF_FILE_PATH_STRING_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/fields/SoSFString.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFFilePathString subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/** 
 * @VSGEXT Field containing a file path string.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A field containing a file path string (sequence of characters).
 *   
 *   SoSFFilePathString is equivalent to SoSFString.
 *   Using this type of field provides a way for Open Inventor to do conversion and
 *   filtering operations on distributed heterogeneous systems.
 *
 * @SEE_ALSO
 *    SbString,
 *    SoField,
 *    SoSField,
 *    SoSFString
 *    SoMFString
 *    SoMFFilePathString
 * 
 * 
 */
class INVENTOR_API SoSFFilePathString : public SoSFString {
  // Use standard field stuff
  SO_SFIELD_DERIVED_HEADER(SoSFFilePathString, SbString, const SbString &);
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  // do some filtering on filePath value before read/write
  static void cleanupValue(SbString& SO_UNUSED_PARAM(filePath));

  private:
  // store some path info about the field
  SbStringList directories_stack;
};

#endif /* _SO_SF_FILE_PATH_STRING_ */

