/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SOSFMATERIAL_H
#define SOSFMATERIAL_H

#include <Inventor/fields/SoSFFieldContainer.h>
#include <Inventor/nodes/SoMaterial.h>

/**
* Field containing an SoMaterial node
*
* @ingroup fields
*
* @DESCRIPTION
*   This field maintains a pointer to an instance of an SoMaterial node, 
*   correctly maintaining its reference count.  The same SoMaterial node
*   may be referenced in multiple SoSFMaterial fields.
*
* @SEE_ALSO
*   SoSFNode, SoVolumeDataDrawStyle
*/
class INVENTOR_API SoSFMaterial : public SoSFFieldContainer
{
  SO_SFIELD_DERIVED_HEADER(SoSFMaterial, SoMaterial*, SoMaterial*);

public:
  /** Return current value */
  /** [OIVNET-WRAPPER PROPERTY{Value},GETTER] */
  SoMaterial* getValue() const {
    evaluate();
    return (SoMaterial*)value;
  }

SoINTERNAL public:

  static void initClass();
  static void exitClass();
};

#endif


