/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#pragma once

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>

/**
 * Field containing a 3x3 matrix.
 *
 * @ingroup fields
 *
 * @DESCRIPTION
 *   A field containing a 3x3 transformation matrix (an SbMatrix3).
 *
 *   SoSFMatrix3 is written to a file as 9 floating point numbers separated by
 *   whitespace. For example, an identity matrix is written as:
 *
 *   \verbatim
      1 0 0 0 1 0 0 0 1
     \endverbatim
 *
 *
 * @SEE_ALSO
 *    SoField,
 *    SoSField,
 *    SoSFMatrix,
 *    SoMFMatrix,
 *    SbMatrix
 *    SbMatrix3
 *
 *
 */
class INVENTOR_API SoSFMatrix3 : public SoSField
{
  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFMatrix3, SbMatrix3, const SbMatrix3 &);

 public:
  /**
   * Sets this field to contain the matrix given by the 9 values.
   */
  void                setValue(float a11, float a12, float a13,
                               float a21, float a22, float a23,
                               float a31, float a32, float a33);

 SoINTERNAL public:
  static void         initClass();
  static void exitClass();

};

