/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_ROTATION_
#define  _SO_SF_ROTATION_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFRotation subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Field containing a rotation.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A field containing a single SbRotation (an arbitrary rotation).
 *   
 *   SoSFRotations are written to file as four floating point values separated by
 *   whitespace. The 4 values represent an axis of rotation followed by the amount of
 *   right-handed rotation about that axis, in radians. For example, a 180 degree
 *   rotation about the Y axis is:
 *   
 *   \verbatim
      0 1 0 3.14159265
     \endverbatim
 * NOTE: When you specify an SoSFRotation value using setValue with
 * 4 floating point values,
 * those values will be interpreted as a quaternion (x, y, z, w) rather than
 * an axis and a rotation. To specify an SoSFRotation value using an
 * axis and a rotation, you must use 
 * the following method: setValue(const SbVec3f &axis, float angle).  
 * 
 * @SEE_ALSO
 *    SbRotation,
 *    SoField,
 *    SoSField,
 *    SoMFRotation
 * 
 * 
 */
class INVENTOR_API SoSFRotation : public SoSField {
  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFRotation, SbRotation, const SbRotation &);

 public:
  //
  // Some additional convenience functions:
  //

  /**
   * Gets the value of the field as an axis/angle.
   * [OIVJAVA-WRAPPER NO_WRAP]
   */
  void        getValue(SbVec3f &axis, float &angle) const
    { evaluate(); value.getValue(axis, angle); }

  /**
   * Sets the field to the given quaternion (x, y, z, w).
   */
  void        setValue(float q0, float q1, float q2, float q3);
    
  /**
   * Sets the field to the given quaternion (x, y, z, w).
   */
  void        setValue(const float q[4]);

  /**
   * Sets the field to the rotation given by axis/angle.
   */
  void        setValue(const SbVec3f &axis, float angle);

  /**
   * Convenience method that allows you to specify a field value using a double
   * precision variable. Note that Open Inventor fields still store only single
   * precision values, not double precision values. The specified value is converted
   * to single precision, then stored.
   */
  void    setValue(const SbRotationd &rotd);

 SoINTERNAL public:
  static void         initClass();
  static void exitClass();

};

#endif /* _SO_SF_ROTATION_ */

