/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_STRING_
#define  _SO_SF_STRING_

#include <Inventor/fields/SoSubField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFString subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Field containing a string.
* 
* @ingroup fields
* 
* @DESCRIPTION
*   A field containing an string (sequence of characters).
*   
*   SoSFStrings are written to file as a sequence of ASCII characters in double
*   quotes (optional if the string doesn't contain any whitespace). Any characters
*   (including newlines) may appear within the quotes. To include a double quote
*   character within the string, precede it with a backslash. For example:
*   
*   \verbatim
     Testing
     "One, Two, Three"
     "He said, \"Immel did it!\""
    \endverbatim
*    are all valid strings.
*
* Unicode Support
* 
*    Unicode is an industry standard for encoding text of all forms and 
*    languages for use by computers. Open Inventor supports Unicode 
*    encoding, which allows internationalization of text in a standard 
*    cross-platform fashion. 
*
*    \if_cpp  
*    String as well as classes like SoSFString 
*    support the wchar_t type which is used for Unicode 
*    strings, and all of the text nodes are able to render Unicode 
*    strings.
*
*    SbString includes methods for construction of Unicode strings,
*    string operators (=, += ,== ,!=, <, >, <=, >=), as well as a
*    query method (SbString::isUnicode()).
*
*    \endif
*    To be able to display a particular Unicode character, the 
*    selected font must have a character for that Unicode value. Many
*    fonts do not contain a complete set of Unicode characters.
*    However, the shareware Unicode font file "Code2000" seems to work 
*    well. 
*  
*    Note that Unicode characters are not directly supported in 
*    Open Inventor files. Unicode strings are written as if the bytes in
*    the string were a string of 8-bit characters. The string will be 
*    prefixed by "MCS_U_". 
*
* @SEE_ALSO
*    SoField,
*    SoSField,
*    SoMFString
* 
* 
*/
class INVENTOR_API SoSFString : public SoSField {
  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFString, SbString, const SbString &);

 public:
  //
  // Some additional convenience functions:
  //

  /**
   * Convenience method to set the field's value given a character array.
   *[OIV-WRAPPER-NOT-WRAP]
   *
   * @UNICODE_WARNING
   */
  SoNONUNICODE void setValue(const char *string);

  /**
   * Convenience method to set the field's value given a character array.
   */
  void setValue(const SO_WCHAR_T *string);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

};

#endif /* _SO_SF_STRING_ */

