/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_TRIGGER_
#define  _SO_SF_TRIGGER_

#include <Inventor/fields/SoSubField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFTrigger subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Field used to trigger engines or connection networks.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   This class can be used to start or to synchronize a network of field
 *   connections. It is the "null" field - a field with no values. It is typically
 *   used as the "start button" for engines that change over time.
 *   
 *   Triggers can be connected from any other type of field, and will notify any
 *   engines or nodes they are part of (or any other triggers they are connected to)
 *   whenever the value of the field is set (even if it is set to its current value)
 *   or the field is touch()'ed.
 *   
 *   Since they have no value, SoSFTriggers are not written to file. A node or engine
 *   containing an SoSFTrigger field will write only the field's name.
 * 
 * @SEE_ALSO
 *    SoSFBool,
 *    SoMFBool
 * 
 * 
 */
class INVENTOR_API SoSFTrigger : public SoSField {

  // Use standard field stuff
  SO_SFIELD_REQUIRED_HEADER(SoSFTrigger);
  SO_SFIELD_CONSTRUCTOR_HEADER(SoSFTrigger);

 public:
  /**
   * Starts the notification process; this is equivalent to calling touch().
   */
  void                setValue()              { touch(); }

  /**
   * Forces any connected engines or fields to evaluate themselves.
   */
  void                getValue() const        { }

  // Start notification.
  virtual void        touch();

  /**
   * All trigger fields are equal. This method always returns TRUE.
   */
  int                 operator ==(const SoSFTrigger &t) const;
  /**
   * All trigger fields are equal. This method always returns FALSE.
   */
  int                 operator !=(const SoSFTrigger &t) const;

 SoINTERNAL public:
  static void         initClass();
  static void exitClass();

  // Notification can flow through a trigger, but can't start at a
  // trigger.  The only way to start notification at a trigger is to
  // call touch().
  virtual void        startNotify();

  // Override notify to always evaluate (after passing on
  // notification) to clear upstream dirty bits
  virtual void        notify(SoNotList *list);

 private:
  // Reading and writing. These are no-ops.
  virtual SbBool      readValue(SoInput *in);
  virtual void        writeValue(SoOutput *out) const;

};

#endif /* _SO_SF_TRIGGER_ */

