/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : ... (MMM yyyy)
** Modified by : ... (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_GESTURE_EVENT_
#define  _SO_GESTURE_EVENT_

#include <Inventor/SbBasic.h>
#include <Inventor/events/SoSubEvent.h>


/** 
 * Base class for gesture events.
 * 
 * @ingroup GesturesEvents
 * 
 * @DESCRIPTION
 *   SoGestureEvent represents a series of touch events beginning with begin state and finishing with end state. 
 *   It is the base class for gesture events in the Open Inventor model. Gesture events can be handled using
 *   (for example) an SoEventCallback node.
 *
 *   All touch events are analyzed by recognizers. When a gesture is recognized, the recognizer generates the 
 *   corresponding event. This class stores the begin/delta/end state of the gesture when the event occurred.
 *
 *   @B Note@b: 
 *   - In order to get touch events for the gesture recognizer(s) to recognize, the application must 
 *     explicitly register a touch screen device (SoWinTouchScreen, SoQtTouchScreen, etc).
 *   - In order to get gesture events, the application must explicitly register gesture recognizers
 *     with the touch screen device's touch manager (SoTouchManager).
 *
 * @SEE_ALSO
 *    SoEvent,
 *    SoRotateGestureEvent,
 *    SoScaleGestureEvent,
 *	  SoTapGestureEvent,
 *    SoGestureRecognizer
 *
 */
class INVENTOR_API SoGestureEvent : public SoEvent {
	
  SO_EVENT_HEADER();

public:

  /** The different states a gesture event can have. */
  enum GestureState {
    /**
     *  Begin state : Initial state.
     */
    BEGIN, 
    /**
     *  Delta state : Begin event has been generated, the gesture is updated.
     */
    DELTA,
    /**
     *  End state : Final gesture state.
     */
    END
  };

  /** Constructor */
  SoGestureEvent();

  /**
   *  Destructor.
   */
  virtual ~SoGestureEvent();

  /**
   *  Gets the gesture event state (Begin,Delta,End).
   *  @useenum{GestureState}.
   */
  GestureState getGestureState() const;

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /**
   *  Sets the state of the gesture event.
   */
  void setGestureState(GestureState state);

private:
  // State of the gesture event.
  GestureState m_gestureState;
};

#endif /* _SO_GESTURE_EVENT */


