/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : ... (MMM yyyy)
** Modified by : ... (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_LONG_TAP_GESTURE_EVENT_
#define  _SO_LONG_TAP_GESTURE_EVENT_

#include <Inventor/SbBasic.h>
#include <Inventor/events/SoSubEvent.h>
#include <Inventor/gestures/events/SoGestureEvent.h>

/**
 *
 * Class for long tap gesture events.
 * 
 * @ingroup GesturesEvents
 * 
 * @DESCRIPTION
 *    SoLongTapGestureEvent represents a long tap (touch-and-hold) gesture event in the Open Inventor event model.
 *    Touch events are analyzed by a SoLongTapGestureRecognizer. When a long tap gesture is recognized, 
 *    the recognizer generates this event. It's a gesture with only END state (only one
 *    event is generated, at the end of the gesture).
 *    The finger has to stay within a limitation area and the gesture must be completed
 *    within a time limit (see SoLongTapGestureRecognizer).
 *
 *   @B Note@b: 
 *   - In order to get touch events for the gesture recognizer(s) to recognize, the application must 
 *     explicitly register a touch screen device (SoWinTouchScreen, SoQtTouchScreen, etc).
 *   - In order to get gesture events, the application must explicitly register gesture recognizers
 *     with the touch screen device's touch manager (SoTouchManager).
 *
 * @SEE_ALSO
 *    SoEvent,
 *    SoGestureEvent,
 *    SoRotateGestureEvent,
 *    SoScaleGestureEvent,
 *    SoDoubleTapGestureEvent;
 *    SoLongTapGestureRecognizer
 */
class INVENTOR_API SoLongTapGestureEvent : public SoGestureEvent {

  SO_EVENT_HEADER();

public :

  /** Constructor */
  SoLongTapGestureEvent();

  #ifndef HIDDEN_FROM_DOC
  virtual ~SoLongTapGestureEvent();
  #endif // HIDDEN_FROM_DOC

  /** Returns duration of long tap */
  SbTime getDuration() const;

  /** Sets duration of long tap (in seconds) */
  void setDuration(SbTime time);
  
SoINTERNAL public:
  static void initClass();
  static void exitClass();

private :
  SbTime m_duration;
};

#endif /* _SO_LONG_TAP_GESTURE_EVENT_ */


