/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : ... (MMM yyyy)
** Modified by : ... (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_SCALE_GESTURE_RECOGNIZER_
#define  _SO_SCALE_GESTURE_RECOGNIZER_

#include <Inventor/SbBasic.h>
#include <Inventor/events/SoSubEvent.h>
#include <Inventor/gestures/recognizers/SoGestureRecognizer.h>
#include <Inventor/gestures/events/SoScaleGestureEvent.h>
#include <Inventor/touch/SoTouchManager.h>

/**
 *
 * Scale (pinch) gesture recognizer.
 * 
 * @ingroup GesturesRecognizers
 * 
 * @DESCRIPTION
 *   SoScaleGestureRecognizer analyses touch events and recognizes a scale (two
 *   finger pinch) gesture.
 *   It returns an SoScaleGestureEvent (pinch) event if this gesture is recognized. 
 *   The scale event contains the scale factor between the current state and the initial one.
 *   This recognizer generates a BEGIN event, followed by DELTA events and finishing with an END event
 *   (SoGestureEvent::getGestureState()).
 *
 *   @B Note@b: 
 *   - In order to get touch events for the gesture recognizer(s) to recognize, the application must 
 *     explicitly register a touch screen device (SoWinTouchScreen, SoQtTouchScreen, etc).
 *   - In order to get gesture events, the application must explicitly register gesture recognizers
 *     with the touch screen device's touch manager (SoTouchManager).
 *
 * @SEE_ALSO
 *    SoGestureRecognizer,
 *    SoRotateGestureRecognizer,
 *    SoDoubleTapGestureRecognizer,
 *    SoLongTapGestureRecognizer,
 *    SoScaleGestureEvent
 * 
 */
class INVENTOR_API SoScaleGestureRecognizer : public SoGestureRecognizer {
public :

  /** Constructor */
  SoScaleGestureRecognizer();

  /** Destructor */
  virtual ~SoScaleGestureRecognizer();

  /**
   * If two fingers are "pinching" on the screen, it returns an event with the ratio between the current 
   * distance between fingers and the initial distance when the second finger was put down.
   * If no gesture has been recognized, returns null.
   * \if_cpp Returns a pointer to an internal data object. Do not modify or delete this object. \endif
   */
  SoEvent* recognize(SoEvent* touchEvent); 
  
private:
  int64_t m_finger1ID;
  int64_t m_finger2ID;
  bool m_recoInProgress;

  SoScaleGestureEvent m_returnedEvent;
};

#endif /* _SO_SCALE_GESTURE_RECOGNIZER_ */


