/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Jun 2003)
**=======================================================================*/

#ifndef _SOBMPIMAGERW_
#define _SOBMPIMAGERW_

#include <Inventor/image/SoRasterImageRW.h>

SO_PIMPL_PUBLIC_DECLARATION(SoBMPImageRW);

/**
 *
 * @VSGEXT Class for encoding and decoding a BMP raster image
 * 
 * @ingroup Image
 *
 * This class is used for encoding and decoding a BMP raster image.
 *
 * The writeCapability is WRITE_FULL_IMAGE and isMultipleBufferInverted is FALSE.
 *
 * See SoRasterImageRW for more information and code examples.
 * 
 * @SEE_ALSO
 *    SoRasterImageFile,
 *    SoRasterImageRW,
 *    SbRasterImage
 * 
 * 
 */
class INVENTOR_API SoBMPImageRW : public SoRasterImageRW {

  SO_IMAGE_RASTER_RW_HEADER()
  SO_PIMPL_PUBLIC_HEADER(SoBMPImageRW);

public:

  /**
   * Constructor.
   */
  SoBMPImageRW();

  /**
   * Destructor.
   */
  virtual ~SoBMPImageRW();

  /**
   * Opens the reader/writer in the specified open mode.
   */
  virtual SbBool open(SoRasterImageIO* rasterImageIO, OpenMode SO_UNUSED_PARAM(openMode));
  /**
   * Closes the reader/writer.
   */

  virtual void close();

  /**
   * Writes the given data in this specific format.
   */
  virtual SbBool write(SbRasterImage* SO_UNUSED_PARAM(rasterImage), unsigned int SO_UNUSED_PARAM(xPos) = 0, unsigned int SO_UNUSED_PARAM(yPos) = 0);

  /**
   * Writes and encodes the footer of this specific format.
   */
  virtual SbBool writeFooter();

  /**
   * Reads, decodes, and fills the @I rasterImage@i parameter.
   * If @I infoOnly@i is TRUE, then the buffer will not be read; the parameter @I rasterImage@i will be
   * set with raster size and raster number of components, the buffer will be NULL.
   */
  virtual SbBool read(SbRasterImage* SO_UNUSED_PARAM(rasterImage), SbBool SO_UNUSED_PARAM(infoOnly) = FALSE);

  /**
   * Returns the write direction when using multiple buffers.
   * Returns FALSE if buffers are written from top to bottom.
   * Returns TRUE if buffers are written from bottom to top.
   */
  virtual SbBool isMultipleBufferInverted() const;
  /**
   * Returns the write capability of the raster format.
   */

  virtual SoRasterImageRW::WriteCapability getWriteCapability() const;

  /**
   * Returns the read capability of the raster format.
   */
  virtual SoRasterImageRW::ReadCapability getReadCapability() const;

SoINTERNAL public:
  static SbBool checkWriteFormatAbility( SbRasterImage::Components _comp ); 

protected:
  virtual void createSuffixList();

private:
  SbBool writeImage(SbRasterImage* rasterImage);
  SbBool writeMultipleImages(SbRasterImage* SO_UNUSED_PARAM(rasterImage), unsigned int SO_UNUSED_PARAM(xPos) = 0, unsigned int SO_UNUSED_PARAM(yPos) = 0);

#if defined(_WIN32)
  SbBool internalBitmapReader( SbRasterImage* rasterImage, const SbString& fname, SbBool infoOnly = FALSE );
#endif

  unsigned char*  m_imageBuffer;
  SbBool          m_writeMode;

};

#endif
