/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Jun 2003)
**=======================================================================*/


#ifndef _SOJP2IMAGERW_
#define _SOJP2IMAGERW_

#include <Inventor/image/SoRasterImageRW.h>


SO_PIMPL_PUBLIC_DECLARATION(SoJP2ImageRW);

/**
 *
 * @VSGEXT Class for encoding and decoding a JPEG2000 raster image
 * 
 * @ingroup Image
 *
 * This class is used for encoding and decoding a JPEG2000 raster image.
 * This class also support reading of ECW and ECWP file format.
 *
 * The writeCapability is WRITE_FULL_IMAGE and isMultipleBufferInverted is FALSE.
 *
 * See SoRasterImageRW for more information and code examples.
 *
 * @SEE_ALSO
 *    SoRasterImageFile,
 *    SoRasterImageRW,
 *    SbRasterImage
 * 
 * 
 */
class INVENTOR_API SoJP2ImageRW : public SoRasterImageRW {

  SO_IMAGE_RASTER_RW_HEADER()
  SO_PIMPL_PUBLIC_HEADER(SoJP2ImageRW);

public:

  /**
   * Constructor.
   */
  SoJP2ImageRW();

  /**
   * Destructor.
   */ 
  virtual ~SoJP2ImageRW();

  /**
   * Opens the reader/writer in the specified open mode.
   * Returns true if successful.
   */
  virtual SbBool open(SoRasterImageIO* rasterImageIO, OpenMode openMode);

  /**
   * Writes and encodes the given data in this specific format.
   * If you are using the multiple writing mode, then you can specify the 
   * offset (with xPos,yPos) you want to write to.
   */
  virtual SbBool write(SbRasterImage* rasterImage, unsigned int xPos = 0, unsigned int yPos = 0);

  /**
   * Read the current open image into rasterImage.
   * Returns true if successful. Call the open() method before calling this method.
   *
   * If @I infoOnly@i is TRUE, then the buffer will not be read; the parameter @I rasterImage@i will be
   * set with raster size and raster number of components, the buffer will be NULL.
   *
   * @warning This function doesn't work with SoRasterImageIO containing only FILE*,
   * but work fine with SoRasterImageIO with file name.
   */
  virtual SbBool read(SbRasterImage* rasterImage, SbBool infoOnly = FALSE);

  /**
   * Read the specified region of current open image into rasterImage.
   * Returns true if successful. Call the open() method before calling this method.
   *
   * After calling this method successfully, the size of the SbRasterImage is the
   * requested region size. The requested region may extend outside the source image.
   * In this case, undefined pixels are set to zero. The region may be as small as a
   * single pixel, e.g. (1,1,1,1), but xmin must be <= xmax and ymin <= ymax.
   *
   * @warning This function doesn't work with SoRasterImageIO containing only FILE*,
   * but work fine with SoRasterImageIO with file name.
   */
  virtual SbBool readRegion(SbRasterImage* rasterImage, const SbBox2i32& region);

  /**
   * Returns the write direction when using multiple buffers.
   * Returns FALSE if buffers are written from top to bottom.
   * Returns TRUE if buffers are written from bottom to top.
   */
  virtual SbBool isMultipleBufferInverted() const;

  /**
   * Returns the write capability of the raster format.
   */
  virtual SoRasterImageRW::WriteCapability getWriteCapability() const;

  /**
   * Returns the read capability of the raster format.
   */
  virtual SoRasterImageRW::ReadCapability getReadCapability() const;

  /**
   * Sets the output quality of the image, from 0.0 (lowest quality)
   * to 1.0 (highest quality).  Default is 0.7
   */
  void  setOutputQuality(float quality);

  /**
   * Returns the output quality.
   */
  float getOutputQuality() const;

protected:
  virtual void createSuffixList();
};
#endif
