/*=================================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
***                                                                            ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
***                                                                            ***
***                        RESTRICTED RIGHTS LEGEND                            ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
***                                                                            ***
***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                    ***
***                              BORDEAUX, FRANCE                              ***
***                            ALL RIGHTS RESERVED                             ***
=================================================================================*/


#pragma once

#include <Inventor/image/SoRasterImageRW.h>

SO_PIMPL_PUBLIC_DECLARATION( SoMRCImageRW );

/**
 * @VSGEXT Class for encoding and decoding an MRC raster image
 *
 * @ingroup Image
 *
 * This class is used for encoding and decoding a MRC raster image.
 *
 * MRC is a file format that has become industry standard in cryo-electron microscopy
 * (cryoEM) and electron tomography (ET), where the result of the technique is a
 * three-dimensional grid of voxels each with a value corresponding to electron density
 * or electric potential. It was developed by the MRC (Medical Research Council, UK)
 * Laboratory of Molecular Biology. In 2014, the format was standardised. The format
 * specification is available on the CCP-EM website.  For details see:
 * http://www.ccpem.ac.uk/mrc_format/mrc2014.php
 *
 * The writeCapability is WRITE_UNAVAILABLE and isMultipleBufferInverted is TRUE.
 *
 * See SoRasterImageRW for more information and code examples.
 *
 * <b>NOTE</b>: Class available since Open Inventor 10.4.
 *
 * @SEE_ALSO
 *    SoRasterImageFile, SoRasterImageRW, SbRasterImage, SoVRMrcFileReader
 *
 *
 */
class INVENTOR_API SoMRCImageRW : public SoRasterImageRW {

  SO_IMAGE_RASTER_RW_HEADER()
  SO_PIMPL_PUBLIC_HEADER(SoMRCImageRW);

public:

  /**
   * Constructor.
   */
  SoMRCImageRW();

  /**
   * Destructor.
   */
  virtual ~SoMRCImageRW();

  /**
   * Opens the reader/writer in the specified open mode.
   * Returns true if successful.
   */
  virtual SbBool open(SoRasterImageIO* rasterImageIO, OpenMode openMode);

  /**
   * Writes and encodes the given data in the specific format.
   * If you are using the multiple writing mode, then you can specify the
   * offset (with xPos,yPos) you want to write to.
   */
  virtual SbBool write(SbRasterImage* rasterImage, unsigned int xPos = 0, unsigned int yPos = 0);

  /**
   * Reads, decodes, and fills the @I rasterImage@i parameter.
   * If @I infoOnly@i is TRUE, then the buffer will not be read; the parameter @I rasterImage@i will be
   * set with raster size and raster number of components, the buffer will be NULL.
   */
  virtual SbBool read(SbRasterImage* rasterImage, SbBool infoOnly = FALSE);

  /**
   * @copydoc SoRasterImageRW::read()
   */
  virtual SbBool read(SbRasterImage* rasterImage, size_t imageIndex, SbBool infoOnly = FALSE);

  /**
   * @copydoc SoRasterImageRW::readRegion()
   * @warning This implementation read full image and after copy the desired region.
   */
  virtual SbBool readRegion(SbRasterImage* rasterImage, const SbBox2i32& region);

  /**
   * @copydoc SoRasterImageRW::readRegion()
   */
  virtual SbBool readRegion(SbRasterImage* rasterImage, size_t imageIndex, const SbBox2i32& region);

protected:
  virtual void createSuffixList();

};

