/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Jun 2003)
**=======================================================================*/


#ifndef _SORASTERREADERSET_
#define _SORASTERREADERSET_

#include <Inventor/image/SoRasterImageRW.h>
#include <Inventor/threads/SbThreadRWMutex.h>

#include <Inventor/STL/map>

class SoRasterImageFile; //FORWARD

/**
 *
 * @VSGEXT Class referencing all raster reading classes.
 * 
 * @ingroup Image
 *
 * This class is used to know what readers are available when opening a raster file.
 * All raster readers supplied by Open Inventor are already referenced in SoRasterReaderSet
 * as default readers.
 * The default raster readers are: SoPNGImageRW, SoSGIRGBImageRW, SoGIFImageRW, SoJP2ImageRW, 
 * SoSUNImageRW, SoBMPImageRW, SoPGXImageRW, SoPNMImageRW, SoPSImageRW, SoJPEGImageRW, and SoTIFFImageRW.
 *
 * @SEE_ALSO
 *  SoPNGImageRW,
 *  SoSGIRGBImageRW,
 *  SoGIFImageRW,
 *  SoJP2ImageRW,
 *  SoSUNImageRW,
 *  SoBMPImageRW,
 *  SoPGXImageRW,
 *  SoPNMImageRW,
 *  SoPSImageRW,
 *  SoJPEGImageRW,
 *  SoTIFFImageRW
 * 
 * 
 */
class INVENTOR_API SoRasterReaderSet {

public:
	/**
	* Returns an instance of the reader class if found in the set of raster readers.
	* Returns NULL if no reader found or available.
	*/
	static SoRasterImageRW* getReader(SoRasterImageIO* imageIO);

 /**
  * Adds a raster reading class to the set of raster readers.
  */  
  static void addReader(SoRasterImageRW* reader);

 /**
  * Removes @B num@b readers (including default ones) at @B start@b position.
  * If num is equal to -1, all readers are removed.
  */
  static void deleteReaders(int start, int num = -1);

 /**
  * Returns the type of reader at the specified index.
  */  
  static SoType getReaderAt(int index);

 /**
  * Returns the number of raster readers currently in the set.
  */
  static int getNumReaders();


SoINTERNAL public:
  static void initClasses();
  static void exitClasses();

  static SoRasterImageRW* getReader(SoRasterImageFile* imageFile, const SbString& suffix);

  /** Return reader based only on the filename extension */
  static SoRasterImageRW* getReader(const SbString& filename);

protected:
  SoRasterReaderSet();
  ~SoRasterReaderSet();

private:
  typedef std::vector<SoRasterImageRW*> SoRasterImageRWVector;

  struct ThreadDataStruct
  {
    bool isLoaded;
    SoRasterImageRWVector* readersList;
  };


  static void loadAllReaders();
  static ThreadDataStruct* getCurrentThreadData();

  static SbThreadRWMutex s_readersMutex;
  static SbThreadMutex s_getReaderMutex;
  static std::map<SbThreadId_t, ThreadDataStruct*> s_threadsReaders;

};

#endif


