/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Sep 2014)
**=======================================================================*/


#ifndef _SO_STL_FILE_FORMAT_H_
#define _SO_STL_FILE_FORMAT_H_

#include <Inventor/SbBasic.h>
#include <Inventor/io/STL/SoInventorSTLLibName.h>

// InventorSTL_EXPORTS is defined only when building fei_inventor_io_stl library
#ifdef InventorSTL_EXPORTS
#  define STLFILEFORMAT_API VC_DLL_EXPORT
#else
#  define STLFILEFORMAT_API VC_DLL_IMPORT
#endif

#ifdef _WIN32
#  ifndef InventorSTL_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__INVENTORSTLLIB)
#    endif
#  endif
#endif

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoSTLFileFormat, __INVENTORSTLDLL)

/**
 * @VSGEXT Module class to initialize STL file format support.
 * 
 * @ingroup InventorIOSTL
 * 
 * @DESCRIPTION
 *   This class allows the application to initialize the STL file format support module.
 *
 * \if_cpp
 * [C++] The module must be initialized before using any other classes of the module.
 *   However it is not necessary to explicitly initialize the module when using
 *   SoDB::readAll() to load STL format data.
 * \endif
 *
 *   This format requires redistributing the fei_inventor_io_stl
 *   plugin library with the application (e.g. fei_inventor_io_stl.dll on Windows).
 *
 * Limitations: @BR
 *   - Import is done in float single precision. Precision may be lost if stl file contains
 *     values in double precision.
 *
 * @SEE_ALSO
 *   SoSTLInputReader, SoSTLWriteAction
 */
class STLFILEFORMAT_API SoSTLFileFormat {

 public:

  /**
   * Initializes all classes of STLFileFormat modules by registering them
   * in the database. This function needs to be called before any 
   * other class of STLFileFormat may be constructed or accessed. 
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void init();

  /** 
   * Frees Open Inventor's internal static memory 
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void finish();

  /**
   * Returns a character string identifying the name of the extension.
   */
  static const char *getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */

 SoINTERNAL public:

  // reference counter on the lib.
  static int s_initRefCount;

  static const char *s_versionString;

};
/*---------------------------------------------------------------------------*/

// Declare plugin entry points for dynamic plugin loading
extern "C" STLFILEFORMAT_API void initPlugin();
extern "C" STLFILEFORMAT_API void exitPlugin();

#endif // _SO_STL_FILE_FORMAT_H_

