/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Created by : VSG (mar 2012)
**=======================================================================*/

#ifndef  _SO_INPUT_STL_READER_H_
#define  _SO_INPUT_STL_READER_H_

#include <Inventor/io/STL/SoSTLFileFormat.h>
#include <Inventor/SoInputReader.h>

/**
 * @VSGEXT Class for importing a scene graph from a STL file.
 * 
 * @ingroup InventorIOSTL
 * 
 * @DESCRIPTION
 * This class imports data from an STL format (.stl) file into an Open Inventor scene graph.
 *
 * Both ASCII and binary file formats are supported.
 *
 * It may be efficient to use this class directly to import STL format data when the file
 * format is already known.  For convenience, note that the SoDB::readAll() method will
 * automatically use this class if it detects that the specified file is STL format.
 *
 * Limitations: @BR
 *   - Import is done in float single precision. Precision may be lost if stl file contains
 *     values in double precision.
 *
 * \if_cpp
 * [C++] The STL module must be initialized (see SoSTLFileFormat) before using this class directly.
 * It is not necessary to explicitly initialize the module when using SoDB::readAll().
 * \endif
 * 
 * @SEE_ALSO
 *   SoSTLFileFormat, SoSTLWriteAction
 */
class STLFILEFORMAT_API SoSTLInputReader : public SoInputReader
{
  SO_TYPED_CLASS_HEADER();
public:
  /** Constructor. */
  SoSTLInputReader();

  /** Destructor. */
  virtual ~SoSTLInputReader();

  /** @copydoc SoInputReader::canConvert */
  virtual bool canConvert(SoInput*);

  /** @copydoc SoInputReader::convert */
  virtual SoSeparator* convert(SoInput*);
};

#endif // _SO_INPUT_STL_READER_H_
