/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Sep 2014)
**=======================================================================*/


#ifndef _SO_TO_STL_ACTION_H_
#define _SO_TO_STL_ACTION_H_

#include <Inventor/io/STL/SoSTLFileFormat.h>

#include <Inventor/actions/SoCallbackAction.h>

class SoSTLWriteActionImpl;

/**
 * @VSGEXT Class for exporting a scene graph to an STL file.
 * 
 * @ingroup InventorIOSTL
 * 
 * @DESCRIPTION
 * This class exports an Open Inventor scenegraph into an STL format (.stl) file.
 *
 * ASCII and binary file formats are supported (see #setBinaryOutput() method).
 *
 * Limitations: @BR
 *   - The STL format does not support color or texture information @BR
 *     (and this class does not support any of the non-standard extensions for specifying color).
 *
 *   - The application is responsible for checking if the specified file can be
 *     created (see SbFileHelper).
 *
 * \if_cpp
 * [C++] The STL module must be initialized (see SoSTLFileFormat) before using this class directly.
 * \endif
 * 
 * @SEE_ALSO
 *   SbFileHelper, SoSTLFileFormat, SoSTLInputReader
 */
class STLFILEFORMAT_API SoSTLWriteAction : public SoCallbackAction
{
  SO_ACTION_HEADER(SoSTLWriteAction);
public:
  /** Constructor. */
  SoSTLWriteAction();

  /** Destructor. */
  ~SoSTLWriteAction();

  /**
   * Set the output filename to write to.
   * @param filename the output filename to write to.
   */
  void setOutputFileName( const SbString& filename );

  /**
   * Sets whether output should be ASCII (default) or binary. 
   */
  void setBinaryOutput(bool flag);

  /**
   * Returns current state of binary flag.
   */
  bool isBinaryOutput() const;

  /** @copydoc SoCallbackAction::apply(SoNode*) */
  virtual void apply(SoNode *node);
  virtual void apply(SoPath *path);
  virtual void apply(const SoPathList &pathList, SbBool obeysRules = FALSE);

SoINTERNAL public:
  /** Internally used to initialize the class. */
  static void initClass();
  static void exitClass();

protected:
  /** @copydoc SoCallbackAction::beginTraversal() */
  virtual void beginTraversal(SoNode *);

  /** @copydoc SoCallbackAction::endTraversal() */
  virtual void endTraversal(SoNode *);

  // don't need extra work of compactPath
  virtual SbBool shouldCompactPathLists() const
  { return FALSE; }

private:
  // implementation class
  SoSTLWriteActionImpl* m_impl;
};

#endif //_SO_TO_STL_ACTION_H_
