/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Created by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SB_INT_LIST_H
#define SB_INT_LIST_H

#include <Inventor/SbPList.h>

/**
 * Maintains a list of integer (int) values.
 *
 * @ingroup General
 *
 * @DESCRIPTION
 *   This subclass of SbPList holds lists of integer values (int).
 *
 *
 * [OIV-WRAPPER-CUSTOM-CODE]
 */

SoINTERNAL class INVENTORBASE_API SbIntList : public SbPList
{
  
 public:
  /**
   * Constructors, similar to SbPList
   */
  SbIntList();

  /**
   * 
   */
  SbIntList(int initSize);
  
  // Adds given integer to end of list.
  void append(int integer);

  void set(int index, int val);

  void set(int startIndex, int* values, int numValues);
  
  // Returns index of given integer in list, or -1 if not found
  int find(int integer);
  
  // Inserts given integer in list before integer with given index
  void insert(int integer, int addBefore);
  
  // Returns int with given index.
  int &operator [](int i) const;
};

#endif
