/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Created by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SB_VEC3F_LIST_H
#define SB_VEC3F_LIST_H

#include <Inventor/SbPList.h>

/**
 * Maintains a list of pointers to SbVec3f instances.
 *
 * @ingroup General
 *
 * @DESCRIPTION
 *   This subclass of SbPList holds lists of SbVec3f.
 *
 * @SEE_ALSO
 *    SbVec3f
 *
 *
 * [OIV-WRAPPER-CUSTOM-CODE]
 */

SoINTERNAL class INVENTORBASE_API SbVec3fList : public SbPList
{
 public:
  
  SbVec3fList();
  ~SbVec3fList();
  
  // Adds given SbVec3f pointer to end of list.
  void append(SbVec3f *vec);
  
  // Inserts given integer in list before integer with given index
  void insert(SbVec3f *vec, int addBefore);
  
  // Returns SbVec3f pointer with given index.
  SbVec3f *operator [](int i) const;
};

#endif
