/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef _SO_ACTION_METHOD_LIST_H_
#define _SO_ACTION_METHOD_LIST_H_

#ifndef HIDDEN_FROM_DOC

#include <Inventor/SbPList.h>
#include <Inventor/threads/SbThreadRWMutex.h>

class SoAction;

typedef void SoActionMethod(SoAction *, SoNode *);
typedef void SoActionMethodUserData(SoAction *, SoNode *, void *);

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoActionMethodList
//
//  Internal class.  A list of routines to call, one for each node type.
//
//////////////////////////////////////////////////////////////////////////////

SoINTERNAL class INVENTOR_API SoActionMethodList : public SbPList
{
 public:
  /** Constructor.  Pass in list from parent action. */
  SoActionMethodList(SoActionMethodList *parentList);
  ~SoActionMethodList();

  /** Add a method to the appropriate place in the list. */
  void addMethod(SoType nodeType, SoActionMethod* method);

  /** Add a method to the appropriate place in the list. */
  void addMethod(SoType nodeType, SoActionMethodUserData* method, void* userData);

  /**
   * Flag which indicates if at least one function with user
   * data has been specifed.
   */
  bool hasFunctionWithUserData();
  void* userData(int i);

  // This MUST be called before using the list.  It fills in NULL
  // entries with their parents' method.
  void setUp();

  // These methods need to be public for the protection off the
  // [] operator. The mutex has to be lock and unlock to make
  // the SbPList thread safe. They're used in SoAction::traverse().
  void readlockMutex() { actionMethodListRWMutex->readlock(); }
  void readunlockMutex() { actionMethodListRWMutex->readunlock(); }
  void writelockMutex() { actionMethodListRWMutex->writelock(); }
  void writeunlockMutex() { actionMethodListRWMutex->writeunlock(); }

 private:
  void* parentMethod(SoType);   // Method from parent node
  void* parentMethod(SoType, int&);   // Method from parent node
  SoActionMethodList  *parent;
  int numValidTypes;   // Stores the number of types at most
  // recent setup

  // Dummy action used internally
  static void dummyAction(SoAction *, SoNode *);

  // OIV.NET specific.
  // Function user data. NULL if any present
  SbPList* functionUserData;

  // Mutex to protect access to the SbPList
  SbThreadRWMutex *actionMethodListRWMutex;
};

#endif

#endif // _SO_ACTION_METHOD_LIST_H_

